package com.liquidnet.service.merchant.dto.param;

import com.liquidnet.commons.lang.constant.LnsRegex;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;

@ApiModel(value = "MerchantAuthorizationPermissionParam", description = "授权权限")
@Data
public class MerchantAuthorizationPermissionParam implements java.io.Serializable {
    private static final long serialVersionUID = -8463419578205447151L;

    @ApiModelProperty(position = 10, required = true, value = "权限ID")
    @NotBlank
    private String permissionId;

    @ApiModelProperty(position = 11, required = false, value = "授权开始时间[yyyy-MM-dd HH:mm:ss]", example = "2021-05-10 20:20:20")
    @Pattern(regexp = LnsRegex.Valid.DATETIME_FULL, message = "时间格式有误")
    private String startTime;
    @ApiModelProperty(position = 12, required = false, value = "授权结束时间[yyyy-MM-dd HH:mm:ss]", example = "2021-05-17 20:20:20")
    @Pattern(regexp = LnsRegex.Valid.DATETIME_FULL, message = "时间格式有误")
    private String endTime;
}
