package com.liquidnet.service.adam.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 入场人
 * </p>
 *
 * @author liquidnet
 * @since 2021-04-28
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class AdamEnters implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Integer mid;

    /**
     * 用户id
     */
    private String uid;

    /**
     * 1-大陆身份证,2-港澳通行证,3-台胞证,4-护照,5-军官证
     */
    private Integer type;

    /**
     * 入场人名称
     */
    private String name;

    /**
     * 入场人手机号
     */
    private String mobile;

    /**
     * 入场人身份号码，或护照号码
     */
    private String idCard;

    /**
     * 是否是默认入场人：0-否,1-是，客户第一个入场人默认1
     */
    private Boolean isDefault;

    /**
     * 状态：0-INIT,1-NORMAL,2-INVALID
     */
    private Integer state;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;

    private LocalDateTime deletedAt;

    private String comment;


}
