package com.liquidnet.service.goblin.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@ApiModel(value = "GoblinGoodsSpecVo", description = "商品规格信息")
@Data
public class GoblinGoodsSpecVo implements Serializable, Cloneable {
    private static final long serialVersionUID = 2353354057235207501L;
    @ApiModelProperty(position = 11, value = "规格名称")
    private String specName;
    @ApiModelProperty(position = 12, value = "排序[数值越小排序越前]")
    private String specSort;
    @ApiModelProperty(position = 13, value = "规格值列表")
    private List<GoblinGoodsSpecValueVo> specValues;

    private static final GoblinGoodsSpecVo obj = new GoblinGoodsSpecVo();
    public static GoblinGoodsSpecVo getNew() {
        try {
            return (GoblinGoodsSpecVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinGoodsSpecVo();
        }
    }
}
