package com.liquidnet.service.goblin.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel(value = "GoblinGoodsSpecDto", description = "商品SKU规格")
@Data
public class GoblinGoodsSpecDto implements Serializable, Cloneable {
    private static final long serialVersionUID = 8425727558228094904L;
    @ApiModelProperty(position = 11, value = "规格名称")
    private String specName;
    @ApiModelProperty(position = 11, value = "规格值名称")
    private String specVname;

    private static final GoblinGoodsSpecDto obj = new GoblinGoodsSpecDto();
    public static GoblinGoodsSpecDto getNew() {
        try {
            return (GoblinGoodsSpecDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinGoodsSpecDto();
        }
    }
}
