package com.liquidnet.service.kylin.controller;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.service.IGoblinOrderService;
import com.liquidnet.service.kylin.dto.param.KylinPerformanceSubscribeParam;
import com.liquidnet.service.kylin.service.IKylinPerformancesService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * @author zjp
 * @create 2024-03-06 14:13
 */
@Api(tags = "前端-演出预约")
@RestController
@RequestMapping("performanceSubscribe")
@Slf4j
public class KylinPerformanceSubscribeController {

    @Autowired
    private IKylinPerformancesService iKylinPerformancesService;

    @PostMapping("")
    @ApiOperation("演出预约")
    public ResponseDto<String> performanceSubscribe(HttpServletRequest request, @RequestBody @Validated KylinPerformanceSubscribeParam param) {
        return iKylinPerformancesService.performanceSubscribe(request,param);
    }
    @GetMapping("")
    @ApiOperation("是否预约演出")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "performancesId", value = "演出id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "ticketTimesId", value = "场次id", required = true),
    })
    public ResponseDto<Integer> isSubscribe(@RequestParam("performancesId") String performancesId,
                                            @RequestParam("ticketTimesId") String ticketTimesId) {
        return iKylinPerformancesService.performanceIsSubscribe(performancesId, ticketTimesId);
    }


}
