package com.liquidnet.service.sweet.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.entity.SweetManualShopTfc;
import com.liquidnet.service.sweet.mapper.SweetManualShopTfcMapper;
import com.liquidnet.service.sweet.service.ISweetManualShopTFCService;
import com.liquidnet.service.sweet.utils.RedisTFCDataUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 电子宣传手册商铺表 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-08-09
 */
@Service
public class SweetManualShopTFCServiceImpl extends ServiceImpl<SweetManualShopTfcMapper, SweetManualShopTfc> implements ISweetManualShopTFCService {

    @Autowired
    private SweetManualShopTfcMapper sweetManualShopTFCMapper;
    @Autowired
    private RedisTFCDataUtils redisDataUtils;

    @Override
    public ResponseDto<List<SweetManualShopTfc>> getList(String manualId, Integer type) {
        try {
            List<SweetManualShopTfc> data = sweetManualShopTFCMapper.selectList(Wrappers.lambdaQuery(SweetManualShopTfc.class).eq(SweetManualShopTfc::getManualId, manualId).eq(SweetManualShopTfc::getType, type).eq(SweetManualShopTfc::getStatus, 1));
            return ResponseDto.success(data);
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }

    @Override
    public ResponseDto<SweetManualShopTfc> details(String manualShopId) {
        try {
            SweetManualShopTfc data = sweetManualShopTFCMapper.selectOne(Wrappers.lambdaQuery(SweetManualShopTfc.class).eq(SweetManualShopTfc::getManualShopId, manualShopId).eq(SweetManualShopTfc::getStatus, 1));
            return ResponseDto.success(data);
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }

    @Override
    public ResponseDto<Boolean> add(String manualId, String title, String picUrl, String describe, Integer type, Integer isRecommend, Integer sort) {
        try {
            SweetManualShopTfc sweetManualShop = SweetManualShopTfc.getNew();
            sweetManualShop.setManualShopId(IDGenerator.nextSnowId());
            sweetManualShop.setManualId(manualId);
            sweetManualShop.setTitle(title);
            sweetManualShop.setPicUrl(picUrl);
            sweetManualShop.setDescribes(describe);
            sweetManualShop.setType(type);
            sweetManualShop.setIsRecommend(isRecommend);
            sweetManualShop.setSort(sort);
            sweetManualShop.setStatus(1);
            sweetManualShopTFCMapper.insert(sweetManualShop);
            redisDataUtils.setManualShopRedisData(manualId);
            return ResponseDto.success();
        } catch (Exception e) {
            e.printStackTrace();
            return ResponseDto.failure();
        }
    }

    @Override
    public ResponseDto<Boolean> change(String manualShopId,String manualId, String title, String picUrl, String describe, Integer type, Integer isRecommend, Integer sort) {
        try {
            SweetManualShopTfc sweetManualShop = SweetManualShopTfc.getNew();
            sweetManualShop.setTitle(title);
            sweetManualShop.setPicUrl(picUrl);
            sweetManualShop.setDescribes(describe);
            sweetManualShop.setType(type);
            sweetManualShop.setIsRecommend(isRecommend);
            sweetManualShop.setSort(sort);
            sweetManualShopTFCMapper.update(sweetManualShop, Wrappers.lambdaUpdate(SweetManualShopTfc.class).eq(SweetManualShopTfc::getManualShopId, manualShopId));
            redisDataUtils.setManualShopRedisData(manualId);
            return ResponseDto.success();
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }

    @Override
    public ResponseDto<Boolean> delete(String manualShopId,String manualId) {
        try {
            SweetManualShopTfc sweetManualShop = SweetManualShopTfc.getNew();
            sweetManualShop.setStatus(0);
            sweetManualShopTFCMapper.update(sweetManualShop, Wrappers.lambdaUpdate(SweetManualShopTfc.class).eq(SweetManualShopTfc::getManualShopId, manualShopId));
            redisDataUtils.setManualShopRedisData(manualId);
            return ResponseDto.success();
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }

}
