package com.liquidnet.client.admin.web.controller.zhengzai.merchant;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.client.admin.common.annotation.Log;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.common.enums.BusinessType;
import com.liquidnet.client.admin.common.utils.ShiroUtils;
import com.liquidnet.client.admin.zhengzai.merchant.service.IMerchantCompaniesAdminService;
import com.liquidnet.client.admin.zhengzai.merchant.service.IMerchantFieldsAdminService;
import com.liquidnet.client.admin.zhengzai.merchant.utils.MerchantMongoUtil;
import com.liquidnet.service.merchant.dto.param.admin.MerchantFieldsListParam;
import com.liquidnet.service.merchant.dto.vo.MerchantCompaniesVo;
import com.liquidnet.service.merchant.dto.vo.MerchantFieldsVo;
import com.liquidnet.service.merchant.entity.MerchantCompanies;
import com.liquidnet.service.merchant.entity.MerchantFields;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Api(tags = "场地管理")
@Controller
@RequestMapping("merchant/field")
public class MerchantFieldsController extends BaseController {

    private final String prefix = "zhengzai/kylin/field";

    @Autowired
    IMerchantFieldsAdminService merchantFieldsAdminService;

    @Autowired
    IMerchantCompaniesAdminService merchantCompaniesAdminService;

    @Autowired
    MerchantMongoUtil merchantMongoUtil;


    @RequiresPermissions("merchant:field:view")
    @GetMapping()
    public String list() {
        return prefix + "/list";
    }


    @Log(title = "场地列表", businessType = BusinessType.LIST)
    @RequiresPermissions("merchant:field:list")
    @PostMapping("/list")
    @ResponseBody
    public TableDataInfo list(MerchantFieldsListParam param) {
        startPage();
        return getDataTable(merchantFieldsAdminService.list(
                Wrappers.lambdaQuery(MerchantFields.class)
                        .eq(param.getFieldId().length() > 0, MerchantFields::getFieldId, param.getFieldId())
                        .eq(param.getIsOnline() >= 0, MerchantFields::getIsOnline, param.getIsOnline())
                        .eq(param.getClaimStatus() >= 0, MerchantFields::getClaimStatus, param.getClaimStatus())
                        .select(
                                MerchantFields::getFieldId, MerchantFields::getIsOnline, MerchantFields::getClaimStatus, MerchantFields::getUid,
                                MerchantFields::getName, MerchantFields::getLogo,
                                MerchantFields::getCreatedAt
                        )
        ));
    }

    @Log(title = "场地详情", businessType = BusinessType.DETAIL)
    @RequiresPermissions("merchant:field:detail")
    @GetMapping("/details/{fieldId}")
    public String detail(@PathVariable("fieldId") String fieldId, ModelMap mmap) {

        LambdaQueryWrapper<MerchantFields> fieldsLambdaQueryWrapper = Wrappers.lambdaQuery(MerchantFields.class);
        fieldsLambdaQueryWrapper.eq(MerchantFields::getFieldId, fieldId);
        MerchantFields fields = merchantFieldsAdminService.getOne(fieldsLambdaQueryWrapper);

        MerchantFieldsVo fieldsVo = MerchantFieldsVo.getNew();
        fieldsVo.copy(fields);
        if (null != fieldsVo.getCompanyId() && !fieldsVo.getCompanyId().isEmpty()) {
            LambdaQueryWrapper<MerchantCompanies> companiesLambdaQueryWrapper = Wrappers.lambdaQuery(MerchantCompanies.class);
            companiesLambdaQueryWrapper.eq(MerchantCompanies::getCompanyId, fieldsVo.getCompanyId());
            MerchantCompanies companies = merchantCompaniesAdminService.getOne(companiesLambdaQueryWrapper);

            MerchantCompaniesVo companiesVo = MerchantCompaniesVo.getNew();
            companiesVo.copy(companies);
            fieldsVo.setCompaniesVo(companiesVo);
        }

        mmap.put("fieldInfo", fieldsVo);

        return prefix + "/detail";
    }


    @ApiOperation(value = "同步Mysql到MongoDB")
    @Log(title = "同步Mysql到MongoDB", businessType = BusinessType.OTHER)
    @RequiresPermissions("merchant:field:sync:mongo")
    @GetMapping("/sync/mongo")
    @ResponseBody
    public AjaxResult approve() {
        String authUid = ShiroUtils.getUserId().toString();
        String authName = ShiroUtils.getLoginName();

        List<MerchantFields> fields = merchantFieldsAdminService.list();
        for (MerchantFields field : fields) {
            MerchantFieldsVo fieldsVo = MerchantFieldsVo.getNew().copy(field);
            merchantMongoUtil.setFieldsVoByFieldId(fieldsVo.getFieldId(), fieldsVo);
        }

        return toAjax(true);
    }


}
