package com.liquidnet.service.dragon.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.dragon.service.IDragonOrderRefundsService;
import com.liquidnet.service.dragon.utils.PayUtils;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.io.ByteArrayOutputStream;

@RestController
@RequestMapping("refund")
public class RefundController {

    @Autowired
    IDragonOrderRefundsService orderRefundsService;

    @PostMapping("preTest")
    @ApiOperation("发送测试退款redis")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<String> checkCanOrder() {
        orderRefundsService.sendRedisQueue();
        return ResponseDto.success();
    }
}
