package com.liquidnet.service.feign.adam.api;

import com.liquidnet.service.adam.dto.vo.AdamAddressesVo;
import com.liquidnet.service.adam.dto.vo.AdamEntersVo;
import com.liquidnet.service.base.ResponseDto;
import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Component
@FeignClient(name = "liquidnet-service-adam",
        contextId = "FeignAdamBaseClient", path = "",
        fallback = FallbackFactory.Default.class)
public interface FeignAdamBaseClient {

    @PostMapping("enters/query/{id}")
    ResponseDto<AdamEntersVo> queryEnters(@PathVariable(name = "id") String entersId,
                                          @RequestParam(name = "uid", required = false) String uid);

    @PostMapping("addr/query/{id}")
    ResponseDto<AdamAddressesVo> queryAddresses(@PathVariable(name = "id") String addrId,
                                                @RequestParam(name = "uid", required = false) String uid);

    /**
     * 判断是否会员
     *
     * @param uid 用户ID
     * @return 是否会员：true-是
     */
    @GetMapping("member/check/{uid}")
    ResponseDto<Boolean> isMember(@PathVariable String uid);
}
