package com.liquidnet.service.kylin.controller;


import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dto.param.PayOrderParam;
import com.liquidnet.service.kylin.dto.vo.PayResultVo;
import com.liquidnet.service.kylin.service.impl.KylinOrderTicketsServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 订单 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-20
 */
@Api(tags = "前端-订单相关")
@RestController
@RequestMapping("order")
public class KylinOrderTicketsController {

    @Autowired
    private KylinOrderTicketsServiceImpl orderTicketsService;

    @PostMapping("pre")
    @ApiOperation("下单")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<PayResultVo> checkCanOrder(@RequestBody PayOrderParam payOrderParam) {
        return orderTicketsService.checkCanOrder(payOrderParam);
    }

}
