package com.liquidnet.service.kylin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;

import java.time.LocalDateTime;
import java.io.Serializable;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 订单详情
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-20
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class KylinOrderTicketEntities implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Integer mid;

    /**
     * order_ticket_entities_id
     */
    private String orderTicketEntitiesId;

    /**
     * 订单详情关联id
     */
    private String orderId;

    /**
     * 票务id
     */
    private String ticketId;

    /**
     * 用户id
     */
    private String userId;

    /**
     * 场次id
     */
    private String timeId;

    /**
     * 演出id
     */
    private String performanceId;

    /**
     * 入场人证件类型 1大陆身份证 2港澳通行证 3台胞证 4护照 5军官证
     */
    private Integer enterType;

    /**
     * 入场人姓名
     */
    private String enterName;

    /**
     * 入场人联系电话
     */
    private String enterMobile;

    /**
     * 入场人证件号
     */
    private String enterIdCode;

    /**
     * 出票状态: 0未出票 1已出票
     */
    private Integer status;

    /**
     * 大麦同步状态: 0不同步 1待同步 2同步完成 3同步失败
     */
    private Integer sysDamai;

    /**
     * 出票端 例如 pda 验票app android/ios 大麦出票
     */
    private String checkClient;

    /**
     * 支付状态: 0未支付 1已支付 2退款中 3已退款
     */
    private Integer isPayment;

    /**
     * comment
     */
    private String comment;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 修改时间
     */
    private LocalDateTime updatedAt;

    /**
     * 获取 添加 数据库参数
     *
     * @return
     */
    public Object[] getAddObject() {
        return new Object[]{
                orderTicketEntitiesId, orderId, ticketId, userId, timeId, performanceId, enterType,
                enterName, enterMobile, enterIdCode, status, sysDamai, checkClient, isPayment, comment,
                createdAt, updatedAt
        };
    }
}
