package com.liquidnet.service.platform.service.impl.stone;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.common.cache.redis.util.RedisDataSourceUtil;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.HttpUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.adam.constant.AdamRedisConst;
import com.liquidnet.service.adam.dto.vo.AdamUserInfoVo;
import com.liquidnet.service.adam.entity.AdamUser;
import com.liquidnet.service.adam.mapper.AdamUserMapper;
import com.liquidnet.service.feign.stone.api.FeignStoneIntegralClient;
import com.liquidnet.service.kylin.mapper.KylinOrderTicketsMapper;
import com.liquidnet.service.stone.constant.StoneConstant;
import com.liquidnet.service.stone.entity.StoneScoreLogs;
import com.liquidnet.service.stone.entity.StoneScoreUser;
import com.liquidnet.service.stone.mapper.StoneScoreLogsMapper;
import com.liquidnet.service.stone.mapper.StoneScoreUserMapper;
import com.liquidnet.service.stone.vo.StoneUserVo;
import com.liquidnet.service.sweet.constant.SweetConstant;
import com.liquidnet.service.sweet.vo.SweetAppletUsersVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

@Service
@Slf4j
public class StoneServerImpl {

    @Value("${liquidnet.service.stone.url}")
    private String stoneUrl;

    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private RedisDataSourceUtil redisDataSourceUtil;
    private static final List<String> defaultBackgroundList = Arrays.asList("https://img.zhengzai.tv/other/2021/07/27/150eeb0e20af4fc88e8a1ec57c46c362.png", "https://img.zhengzai.tv/files/2021/01/13/5ffeab3584b7d.png", "http://pic.zhengzai.tv/default/background.png", "http://img.zhengzai.tv/album/20171027/1509106243302.png");

    @Autowired
    AdamUserMapper userMapper;
    @Autowired
    KylinOrderTicketsMapper orderTicketsMapper;
    @Autowired
    StoneScoreUserMapper stoneScoreUserMapper;
    @Autowired
    StoneScoreLogsMapper stoneScoreLogsMapper;
    @Autowired
    FeignStoneIntegralClient stoneIntegralClient;


    public boolean initScore(int page, int size) {
        try {

        } catch (Exception e) {
            log.info("异常 : {} ", e);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    /**
     * 创建 用户积分
     *
     * @param data
     * @return
     */
    private Object userCreate(StoneUserVo data) {
        return mongoTemplate.insert(data, StoneUserVo.class.getSimpleName());
    }

    private String getUnionIdByPhone(String phone) {
        log.info("mobile = " + phone);
        String redisKey = SweetConstant.REDIS_KEY_SWEET_APPLET_USERS_PHONE.concat(phone);
        Object obj = redisDataSourceUtil.getRedisSweetUtil().get(redisKey);
        if (null == obj) {
            return null;
        }
        SweetAppletUsersVo sweetAppletUsers = (SweetAppletUsersVo) obj;

        String redisKey2 = SweetConstant.REDIS_KEY_SWEET_WECHAT_USERS_UNIONID.concat(sweetAppletUsers.getUnionId())
                .concat(SweetConstant.REDIS_KEY_SWEET_WECHAT_USERS_TYPE).concat(String.valueOf(2));
        Object obj2 = redisDataSourceUtil.getRedisSweetUtil().get(redisKey2);
        if (null == obj2) {
            return null;
        } else {
            return "true";
        }
    }

    private Object logCreate(StoneScoreLogs data) {
        return mongoTemplate.insert(data, StoneScoreLogs.class.getSimpleName());
    }
}
