package com.liquidnet.commons.lang.constant;

public class LnsRegex {
    public static class Valid {
        /**
         * yyyy-MM-dd HH:mm:ss
         */
        public static final String DATETIME_FULL = "^(((((0[48]|[2468][048]|[3579][26])00))|(([0-9]{2})(0[48]|[2468][048]|[13579][26])))[-|.|/| ]0?2[-|.|/| ]29|(((?!0{1,4})[0-9]{1,4})[-|.|/| ](((0[13-9]|1[0-2]|[13-9])[-|.|/| ](29|30))|((0[13578]|(10|12)|[13578])[-|.|/| ]31)|((0(?:[1-9])|1(?:[0-2])|[1-9])[-|.|/| ](0(?:[1-9])|1[0-9]|2[0-8]|[1-9])))))( ((0?[0-9])|(1[0-9]|2[0-3])):(([1-5][0-9])|(0?[0-9])):(([1-5][0-9])|(0?[0-9])))?$";
        /**
         * yyyy-MM-dd
         */
        public static final String DATETIME_YMD = "^(((((0[48]|[2468][048]|[3579][26])00))|(([0-9]{2})(0[48]|[2468][048]|[13579][26])))[-|.|/| ]0?2[-|.|/| ]29|(((?!0{1,4})[0-9]{1,4})[-|.|/| ](((0[13-9]|1[0-2]|[13-9])[-|.|/| ](29|30))|((0[13578]|(10|12)|[13578])[-|.|/| ]31)|((0(?:[1-9])|1(?:[0-2])|[1-9])[-|.|/| ](0(?:[1-9])|1[0-9]|2[0-8]|[1-9])))))$";
        /**
         * 汉字-姓名（2～20位）
         */
        public static final String CHINESE_HANZI = "^[\\u4e00-\\u9fa5]{2,20}$";
        /**
         * 汉字-省|市|区（2～30位）
         */
        public static final String CHINESE_PCD = "^[\\u4e00-\\u9fa5]{2,30}$";
        /**
         * 身份证号（15位||18位）
         */
        public static final String CHINESE_ID_CARD = "(^\\d{15}$)|(^\\d{18}$)|(^\\d{17}(\\d|X|x)$)";
        /**
         * 字母、数字组合
         */
        public static final String LETTER_NUMBER = "^[A-Z0-9]+$";
    }
}
