package com.liquidnet.service.erp.param;

import com.liquidnet.service.erp.constant.ErpEnum;
import lombok.Data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Data
public class TradeListParam implements Cloneable {
    // [必填] 指商城、官网等平台的订单编号，ERP称之为原始单号，同一个sid下通过本接口新增订单的tid保证唯一。
    private String tid;
    // [必填] 平台订单状态较多且涉及变更
    private int trade_status;
    // 平台订单付款状态:0:未付款,1:部分付款,2:已付款
    private int pay_status;

    public int getPay_status() {
        return 2;
    }

    // [必填] 1:款到发货,2:货到付款(包含部分货到付款),3:分期付款,4:挂账
    private int delivery_term;
    // 平台订单创建时间,时间格式：yyyy-MM-dd HH:mm:ss
    private String trade_time;
    // [必填] 平台订单付款时间,时间格式：yyyy-MM-dd HH:mm:ss，未付款订单为:0000-00-00 00:00:00
    private String pay_time;
    //     1:代销  2:经销
    //    private String fenxiao_type;
    // 转供销情况下，采购单ID
    //    private String purchase_id;
    // 分销订单的分销商id,或转供销时供应商id
    //    private String fenxiao_nick;
    //[必填]平台买家昵称，注意：一次推送网名相同的订单不能超过30
    private String buyer_nick;
    // 买家email
    //    private String buyer_email;
    // 支付单号
    private String pay_id;
    // 支付账号
    //    private String pay_account;
    // [必填]收件人姓名
    private String receiver_name;
    // [必填]收件人省份，需与旺店通地址库匹配，点击查看，如果不传省市区，则会尝试从详细地址解析省市区，必须是空格分隔的才能解析成功，需要注意直辖市的地址格式，举例“北京 北京市 海淀区 花园路xxxx”
    private String receiver_province;
    // [必填]收件人城市
    private String receiver_city;
    // [必填]收件人区县
    private String receiver_district;
    // [必填]收件人地址详情
    private String receiver_address;
    // [必填]手机号码
    private String receiver_mobile;
    // 电话号码
    //    private String receiver_telno;
    // 收件人邮编
    //    private String receiver_zip;
    // 不传本参数，输入值默认-1，表示由ERP系统策略选择。平台指定订单发货物流可选输入值单击这里
    //    private String logistics_type;
    // 0:不需要,1:普通发票,2:增值税普通发票电子,3:增值税普通发票纸质,4:增值税专用发票
    //    private String invoice_kind;
    // 发票抬头
    //    private String invoice_title;
    // 常见内容：纳税人识别号、地址、电话、开户银行、银行账户，按照以下格式推送，系统开发票时可解析。
    //推送格式：纳税人识别号:xxxxxxxxxxx;地址:xxxxxxxx 13888888888;开户银行:银行名称 银行账户;
    //英文分号以后是地址，地址后面是空格，空格后面是电话，电话后面是英文分号，分号以后是开户行，然后空格，然后是银行账号
    //    private String invoice_content;
    // 客户备注标旗，取值0至5对应的标旗颜色依次为灰（无标旗）、红、黄、绿、蓝、紫，不传默认0
    //    private String remark_flag;
    // 买家下单时填写的订单备注
    //    private String buyer_message;
    // 商家客服对订单进行的备注内容
    //    private String seller_memo;
    // [客服标旗，取值0至5对应的标旗颜色依次为灰（无标旗）、红、黄、绿、蓝、紫，不传默认0
    //    private String seller_flag;
    // [必填]商家收取买家的物流或者快递费用
    private BigDecimal post_amount;
    // 货到付款金额
    //    private String cod_amount;
    // [必填]货到付款买家费用，扣除货到付款订单金额后，卖家仍需支付的货到付款其他金额。这个钱卖家收不回来，是快递公司直接收走，但在快递单里是要打印出来，否则快递收款就错了
    private BigDecimal ext_cod_fee;
    // [必填]	其它应从买家收取的服务费，其他费用
    private BigDecimal other_amount;
    // [必填]订单已付金额，paid计算公式：paid",Σ(price * num + adjust_amount -discount – share_discount）+ post_amount+other_amount，所有金额相关字段推送处理办法，单击这里
    private BigDecimal paid;
    // 1:身份证（不传默认为0，为0时将证件号码置空）
    //    private String id_card_type;
    // 证件号码
    //    private String id_card;
    // 是否为自动流转模式（1：是 0：不是 不传默认0），非自动流转模式一定不要传值。自动流转模式处理办法，”自动流转模式处理办法详解”)单击这里
    //    private String is_auto_wms;
    // 非自动流转模式一定不要传值
    //    private String wms_type;
    // ERP内自定义的仓库编号，查看路径ERP→设置→基本设置→仓库→仓库列表，测试环境仓库编号查看测试环境分配邮件。平台订单需指定ERP内仓库时，传哪个仓库的编号，ERP将为订单选择哪个仓库。
    private String warehouse_no;
    // [必填]货品明细列表（子订单列表）节点
    private List<OrderListParam> order_list;

    private static final TradeListParam obj = new TradeListParam();

    public static TradeListParam getNew() {
        try {
            return (TradeListParam) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new TradeListParam();
        }
    }

    public HashMap<String, Object> test(String id) {
        HashMap<String, Object> map = new HashMap<>();
        map.put("tid", "testOrderSpu"+id);
        map.put("trade_status", ErpEnum.WdtStatus.STATUS_UN_SEND.WdtStatus());
        map.put("delivery_term", 1);
        map.put("trade_time", "2022-11-30 12:00:00");
        map.put("pay_time", "2022-11-30 12:00:00");
        map.put("buyer_nick", "大美测试");
        map.put("pay_id", "testSku001");
        map.put("receiver_name", "大美");
        map.put("receiver_province", "mdsk01");
        map.put("receiver_city", "01测试");
        map.put("receiver_district", "");
        map.put("receiver_address", "北京市海淀区3-12");
        map.put("receiver_mobile", "15901093014");
        map.put("post_amount", BigDecimal.TEN);
        map.put("ext_cod_fee", BigDecimal.ZERO);
        map.put("other_amount", BigDecimal.ZERO);
        map.put("paid", BigDecimal.TEN);
        map.put("warehouse_no", "mdtk2-test");
        List<Map<String, Object>> orderList = new ArrayList<Map<String, Object>>();
        orderList.add(new OrderListParam().test(id));
        map.put("order_list", orderList);
        return map;
    }

}
