package com.liquidnet.service.candy.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.candy.entity.CandyCoupon;
import com.liquidnet.service.candy.param.BackCouponParam;
import com.liquidnet.service.candy.vo.CandyCouponPreVo;
import com.liquidnet.service.candy.vo.CandyCouponVo;
import com.liquidnet.service.candy.vo.CandyMyCouponListVo;
import com.liquidnet.service.candy.vo.CandyUseResultVo;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 券基础信息 服务类
 * </p>
 *
 * @author liquidnet
 * @since 2021-08-18
 */
public interface ICandyCouponService {

    CandyMyCouponListVo myCoupon(Integer type);

    List<CandyCouponPreVo> memberCouponPre(String uid);

    List<CandyCouponVo> memberCoupon(String mCouponId);

    CandyMyCouponListVo preUsePerformanceCoupon(BigDecimal priceTotal, String performanceId, String timeId, String ticketId, Integer type);

    Integer preCanUsePerformanceCoupon(BigDecimal priceTotal, String performanceId, String timeId, String ticketId);

    CandyMyCouponListVo preUseGoodCoupon(BigDecimal priceTotal, String goodId, Integer type);

    Integer preCanUseGoodCoupon(BigDecimal priceTotal, String goodI);

    List<CandyCouponVo> myAdvanceCoupon(String performanceId);

    Integer stateCoupon(String uCouponId);

    CandyUseResultVo useCoupon(String uCouponId, String content, String totalPrice, String performanceId, String timesId, String ticketId, String goodIds);

    Boolean useBackCoupon(List<BackCouponParam> backCouponParam);

    ResponseDto<Boolean> receiveCoupon(String ccode);

    ResponseDto<CandyCouponVo> receiveCouponDetails(String ccode);

    ResponseDto<List<CandyCouponVo>> couponListById(String uCouponIds);
}
