package com.liquidnet.service.goblin.dto.manage;

import com.liquidnet.commons.lang.constant.LnsRegex;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.goblin.dto.vo.GoblinGoodsSkuInfoVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import javax.validation.constraints.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@ApiModel(value = "GoblinStoreMgtDigitalGoodsSkuAddParam", description = "商品管理:商品编辑:数字商品SKU添加/编辑SKU入参")
@Data
public class GoblinStoreMgtDigitalGoodsAddSkuParam implements Serializable {
    private static final long serialVersionUID = 8312325974060397741L;
    @ApiModelProperty(position = 10, required = true, value = "店铺ID")
    @NotBlank(message = "店铺ID不能为空")
    private String storeId;
    @ApiModelProperty(position = 11, required = true, value = "商品ID")
    @NotBlank(message = "商品ID不能为空")
    private String spuId;
    @ApiModelProperty(position = 12, required = false, value = "单品ID，编辑时必传")
    private String skuId;

    @ApiModelProperty(position = 12, required = false, value = "NFT区块链[zxinchain-至信链|xuper-百度链]", allowableValues = "zxinchain,xuper", example = "zxinchain")
    @Pattern(regexp = "\\b(zxinchain|xuper)\\b", message = "NFT区块链参数无效")
    private String routeType;

    @ApiModelProperty(position = 13, required = true, value = "藏品名称[36]", example = "藏品名称...")
    @NotBlank(message = "藏品名称不能为空")
    @Size(max = 36, message = "藏品名称内容过长")
    @Pattern(regexp = LnsRegex.Valid.ALPHABET_NUMBER_HANZI_SPACE_DOT, message = "藏品名称格式有误，仅支持中英文数字")
    private String name;
    @ApiModelProperty(position = 14, required = true, value = "副标题[36]，`unbox=0`时必传", example = "副标题...")
    @NotBlank(message = "副标题不能为空")
    @Size(max = 36, message = "副标题内容过长")
    @Pattern(regexp = LnsRegex.Valid.ALPHABET_NUMBER_HANZI_SPACE_DOT, message = "副标题格式有误，仅支持中英文数字")
    private String subtitle;
    @ApiModelProperty(position = 15, required = true, value = "藏品封面图片URL[256]", example = "https://img.zhengzai.tv/files/2020/08/31/5f4c75095e9bc.png")
    @NotBlank(message = "藏品封面图片不能为空")
    @Size(max = 256, message = "藏品封面图片URL过长")
    private String skuPic;
    @ApiModelProperty(position = 16, required = true, value = "展示文件URL[256]", example = "https://img.zhengzai.tv/files/2020/08/31/5f4c75095e9bc.png")
    @NotBlank(message = "展示文件不能为空")
    @Size(max = 256, message = "展示文件URL过长")
    private String skuWatch;
    @ApiModelProperty(position = 17, required = true, value = "展示文件类型[1-图片|2-视频|3-模型]", example = "1")
    @NotBlank(message = "展示文件类型不能为空")
    @Pattern(regexp = "\\b(1|2|3)\\b", message = "展示文件类型参数无效")
    private String watchType;
    @ApiModelProperty(position = 17, required = false, value = "展示预览图[256]，展示文件为视频或模型时必传", example = "https://img.zhengzai.tv/files/2020/08/31/5f4c75095e9bc.png")
    @Size(max = 256, message = "展示预览图URL过长")
    private String skuWatchPic;
    @ApiModelProperty(position = 18, required = false, value = "我的藏品展示文件类型[1-图片|2-视频|3-模型]，`unbox=0`时必传", example = "1")
    @Pattern(regexp = "\\b(1|2|3)\\b", message = "我的藏品展示文件类型参数无效")
    private String materialType;
    @ApiModelProperty(position = 19, required = false, value = "我的藏品展示文件URL[256]，`unbox=0`时必传", example = "https://img.zhengzai.tv/files/2020/08/31/5f4c75095e9bc.png")
    @Size(max = 256, message = "我的藏品展示文件URL过长")
    private String materialUrl;

    @ApiModelProperty(position = 20, required = false, value = "线上库存，`unbox=0`时必传", example = "10")
//    @NotNull(message = "线上库存不能为空")
    @Min(value = 0, message = "线上库存必须大于0")
    private Integer stock;
    @ApiModelProperty(position = 22, required = false, value = "盲盒命中率[0.00~100%]，0标识不参与盲盒，null标识均摊，`unbox=1`时有效", example = "0")
    @DecimalMin(value = "0", message = "概率超出可填范围0.00~100")
    @DecimalMax(value = "100", message = "概率超出可填范围0.00~100")
    private BigDecimal hitRatio;
    @ApiModelProperty(position = 23, required = true, value = "藏品价格[20,2]", example = "0.01")
    @NotNull(message = "藏品价格不能为空")
    @DecimalMin(value = "0.01", message = "藏品价格必须大于0")
    private BigDecimal price;
    @ApiModelProperty(position = 23, required = true, value = "IOS价格ID[20]", example = "NGoods1")
    @NotNull(message = "IOS价格ID不能为空")
    private String productId;
//    @ApiModelProperty(position = 24, required = false, value = "藏品会员价格[20,2]", example = "0")
//    @DecimalMin(value = "0.01", message = "藏品会员价格必须大于0")
//    private BigDecimal priceMember;

    @ApiModelProperty(position = 25, required = false, value = "限购[0-无限制|X:限购数量]，`unbox=0`时必传", example = "1")
    @NotNull(message = "限购数量不能为空")
    @Min(value = 1, message = "限购数量必须大于0")
    private Integer buyLimit;
    @ApiModelProperty(position = 26, required = false, value = "购买限制[0-全部用户|1-仅会员]，`unbox=0`时必传", example = "0")
    @NotBlank(message = "购买条件不能为空")
    @Pattern(regexp = "\\b(0|1)\\b", message = "购买条件参数无效")
    private String buyFactor;
    @ApiModelProperty(position = 27, required = false, value = "是否隐藏[0-默认展示|1-隐藏]，`unbox=0`时必传", example = "0")
//    @NotBlank(message = "是否隐藏不能为空")
    @Pattern(regexp = "\\b(0|1)\\b", message = "是否隐藏参数无效")
    private String skuAppear;
    @ApiModelProperty(position = 28, required = false, value = "是否购买[0-否|1-是]，`unbox=0`时必传", example = "1")
//    @NotBlank(message = "是否购买不能为空")
    @Pattern(regexp = "\\b(0|1)\\b", message = "是否购买参数无效")
    private String skuCanbuy;
//    @ApiModelProperty(position = 27, required = false, value = "购买限制人员名单URL，购买限制为2-指定用户时必填")
//    @Size(max = 256, message = "购买限制人员名单URL过长")
//    private String buyRoster;
//    @ApiModelProperty(position = 28, required = false, value = "购买限制人员名单操作类型[1-添加|2-删除]，购买限制为2-指定用户时有效")
//    @Pattern(regexp = "\\b(1|2)\\b", message = "购买限制人员名单操作类型参数无效")
//    private String buyRosterType;

    @ApiModelProperty(position = 29, required = false, value = "简介[256]", example = "简介...")
    @Size(max = 256, message = "藏品简介内容过长")
    private String intro;
    @ApiModelProperty(position = 30, required = true, value = "详情[256]", example = "详情...")
    @NotBlank(message = "藏品详情不能为空")
    @Size(max = 10000, message = "藏品详情内容过长")
    private String details;

//    @ApiModelProperty(position = 31, required = true, value = "上架处理方式[1-等待手动上架|2-直接上架售卖|3-预约定时上架]", example = "1")
//    @NotNull(message = "上架处理方式不能为空")
//    @Pattern(regexp = "\\b(1|2|3)\\b", message = "上架处理方式参数无效")
    @ApiModelProperty(position = 31, required = true, value = "上架处理方式[2-直接上架售卖|3-预约定时上架]", example = "1")
    @NotNull(message = "上架处理方式不能为空")
    @Pattern(regexp = "\\b(2|3)\\b", message = "上架处理方式参数无效")
    private String shelvesHandle;
    @ApiModelProperty(position = 32, required = false, value = "预约上架时间[yyyy-MM-dd HH:mm:ss][上架处理方式为3-预约定时上架时需要指定]", example = "2022-03-25 00:00:00")
    @Pattern(regexp = LnsRegex.Valid.DATETIME_FULL, message = "预约上架时间格式有误")
    private String shelvesTime;
    @ApiModelProperty(position = 33, required = true, value = "开售时间[yyyy-MM-dd HH:mm:ss]", example = "2022-03-25 00:00:00")
    @NotNull(message = "开售时间不能为空")
    @Pattern(regexp = LnsRegex.Valid.DATETIME_FULL, message = "开售时间格式有误")
    private String saleStartTime;

    @ApiModelProperty(position = 34, required = false, value = "是否盲盒[0-否|1-是]", example = "0")
    @Pattern(regexp = "\\b(0|1)\\b", message = "是否盲盒参数无效")
    private String unbox;
    @ApiModelProperty(position = 35, required = false, value = "盲盒开启时间[yyyy-MM-dd HH:mm:ss]，`unbox=1`时必传", example = "2022-03-25 00:00:00")
    @Pattern(regexp = LnsRegex.Valid.DATETIME_FULL, message = "盲盒开启时间格式有误")
    private String openingTime;
//    @ApiModelProperty(position = 36, required = false, value = "盲盒开启时限[单位秒]", example = "0")
//    @Min(value = 0, message = "盲盒开启时限参数无效")
//    private Integer openingLimit;

    /**
     * ---------------------------- 专属标签 ----------------------------
     **/

    @ApiModelProperty(position = 37, required = false, value = "藏品关联音乐人、艺术家、品牌方、厂牌列表")
    private List<String> extagList;


    public GoblinGoodsSkuInfoVo initAddGoodsSkuInfoVo(boolean notUnboxFlg) {
        GoblinGoodsSkuInfoVo initVo = GoblinGoodsSkuInfoVo.getNew();
        initVo.setSkuId(this.getSpuId().concat(StringUtils.right(String.valueOf(System.nanoTime()), 5)));
        initVo.setSpuId(this.getSpuId());
        initVo.setRouteType(StringUtils.isNotBlank(this.getRouteType()) ? this.getRouteType() : "zxinchain");
        initVo.setSkuNo(this.getSpuId());
        initVo.setSkuType(1);
        initVo.setName(this.getName());
        initVo.setSubtitle(this.getSubtitle());
        initVo.setSkuPic(this.getSkuPic());
        initVo.setSkuWatch(this.getSkuWatch());
        initVo.setWatchType(this.getWatchType());
        initVo.setSkuWatchPic(this.getSkuWatchPic());
        initVo.setPrice(this.getPrice());
        initVo.setProductId(this.getProductId());
        initVo.setPriceMember(this.getPrice());
        initVo.setIntro(this.getIntro());
        initVo.setDetails(this.getDetails());
        initVo.setStoreId(this.getStoreId());
        initVo.setShelvesHandle(this.getShelvesHandle());
        initVo.setShelvesTime(this.getShelvesTime());
        initVo.setSaleStartTime(DateUtil.Formatter.yyyyMMddHHmmss.parse(this.getSaleStartTime()));
        initVo.setVirtualFlg("1");
        initVo.setStatus("3");
        initVo.setShelvesStatus("0");
        initVo.setSoldoutStatus("0");
        initVo.setDelFlg("0");

        initVo.setBuyLimit(this.getBuyLimit());//
        initVo.setBuyFactor(this.getBuyFactor());//

        initVo.setUnbox(notUnboxFlg ? "0" : "1");
        if (notUnboxFlg) {
            initVo.setSubtitle(this.getSubtitle());//0
            initVo.setMaterialType(this.getMaterialType());//0
            initVo.setMaterialUrl(this.getMaterialUrl());//0
            initVo.setStock(this.getStock());//0
            initVo.setSkuStock(this.getStock());//0
//            initVo.setGiftStock(this.getGiftStock());//0
            initVo.setHitRatio(this.getHitRatio());//0
//            initVo.setBuyLimit(this.getBuyLimit());//0
//            initVo.setBuyFactor(this.getBuyFactor());//0
            initVo.setSkuAppear(this.getSkuAppear());//0
            initVo.setSkuCanbuy(this.getSkuCanbuy());//0
        } else {
            initVo.setStock(0);
            initVo.setSkuStock(0);
//            initVo.setBuyLimit(this.getBuyLimit());//
//            initVo.setBuyFactor(this.getBuyFactor());//
            initVo.setSkuAppear(null == this.getSkuAppear() ? "0" : this.getSkuAppear());//1
            initVo.setSkuCanbuy(null == this.getSkuCanbuy() ? "1" : this.getSkuCanbuy());//1
            initVo.setOpeningTime(DateUtil.Formatter.yyyyMMddHHmmss.parse(this.getOpeningTime()));//1
        }
        return initVo;
    }

    public GoblinGoodsSkuInfoVo initEditGoodsSkuInfoVo() {
        GoblinGoodsSkuInfoVo updateVo = GoblinGoodsSkuInfoVo.getNew();
        updateVo.setSkuId(this.getSkuId());
        updateVo.setSkuType(1);
//        updateVo.setRouteType(this.getRouteType());

        updateVo.setDetails(this.getDetails());
        updateVo.setShelvesHandle(this.getShelvesHandle());
        updateVo.setShelvesTime(this.getShelvesTime());
        updateVo.setSaleStartTime(DateUtil.Formatter.yyyyMMddHHmmss.parse(this.getSaleStartTime()));

        updateVo.setBuyLimit(this.getBuyLimit());//
        updateVo.setBuyFactor(this.getBuyFactor());//

        switch (this.getUnbox()) {
            case "0":
                updateVo.setHitRatio(this.getHitRatio());//0
//                updateVo.setBuyLimit(this.getBuyLimit());//0
//                updateVo.setBuyFactor(this.getBuyFactor());//0
                updateVo.setSkuAppear(this.getSkuAppear());//0
                updateVo.setSkuCanbuy(this.getSkuCanbuy());//0
                break;
            case "1":
//                updateVo.setBuyLimit(this.getBuyLimit());//
//                updateVo.setBuyFactor(this.getBuyFactor());//
                updateVo.setSkuAppear(null == this.getSkuAppear() ? "0" : this.getSkuAppear());//1
                updateVo.setSkuCanbuy(null == this.getSkuCanbuy() ? "1" : this.getSkuCanbuy());//1
                updateVo.setName(this.getName());//1
                updateVo.setSkuPic(this.getSkuPic());//1
                updateVo.setSkuWatch(this.getSkuWatch());//1
                updateVo.setWatchType(this.getWatchType());//1
                updateVo.setSkuWatchPic(this.getSkuWatchPic());//1
                updateVo.setPrice(this.getPrice());//1
                updateVo.setPriceMember(this.getPrice());//
                updateVo.setIntro(this.getIntro());//1
                updateVo.setOpeningTime(DateUtil.Formatter.yyyyMMddHHmmss.parse(this.getOpeningTime()));//1
                break;
        }
        return updateVo;
    }
}
