package com.liquidnet.service.adam.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

@ApiModel(value = "AdamMemberRightsCouponVo", description = "会员专享特权券")
@Data
public class AdamMemberRightsCouponVo implements java.io.Serializable, Cloneable {
    private static final long serialVersionUID = 4099907681723174194L;
    @ApiModelProperty(position = 1, value = "权益ID")
    private String mrightsId;
    @ApiModelProperty(position = 2, value = "券ID")
    private String couponId;
    @ApiModelProperty(position = 3, value = "券类别[0-全场｜1-演出｜2-商品｜3-优先购]")
    private Integer busiType;
    @ApiModelProperty(position = 4, value = "券类型[1-代金券｜2-满减券｜3-兑换券｜4-折扣券|101-优先券]")
    private Integer couType;
    @ApiModelProperty(position = 5, value = "券标题")
    private String title;
    @ApiModelProperty(position = 6, value = "券标注")
    private String label;
    @ApiModelProperty(position = 7, value = "注意/须知")
    private String notice;
    @ApiModelProperty(position = 8, value = "券面值")
    private BigDecimal valFace;
    @ApiModelProperty(position = 9, value = "满减~满")
    private BigDecimal valOver;
    @ApiModelProperty(position = 10, value = "满减~减")
    private BigDecimal valMinus;
    @ApiModelProperty(position = 11, value = "折扣[8折即0.8]")
    private BigDecimal discount;

    /* com.liquidnet.service.adam.dto.vo.AdamMemberRightsCouponRuleVo */
    private List<AdamMemberRightsCouponRuleVo> useRules;

    private static final AdamMemberRightsCouponVo obj = new AdamMemberRightsCouponVo();

    public static AdamMemberRightsCouponVo getNew() {
        try {
            return (AdamMemberRightsCouponVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new AdamMemberRightsCouponVo();
        }
    }
}
