package com.liquidnet.service.sweet.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.dto.vo.IntegralActivityPrizeVo;
import com.liquidnet.service.sweet.dto.vo.IntegralActivityVo;
import com.liquidnet.service.sweet.entity.SweetIntegralActivity;
import com.liquidnet.service.sweet.mapper.SweetIntegralActivityDrawMapper;
import com.liquidnet.service.sweet.mapper.SweetIntegralActivityMapper;
import com.liquidnet.service.sweet.service.ISweetIntegralActivityService;
import com.liquidnet.service.sweet.utils.ObjectUtil;
import com.liquidnet.service.sweet.utils.RedisDataUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 积分活动表 服务实现类
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-10-25
 */
@Service
public class SweetIntegralActivityServiceImpl extends ServiceImpl<SweetIntegralActivityMapper, SweetIntegralActivity> implements ISweetIntegralActivityService {

    @Autowired
    private RedisDataUtils redisDataUtils;

    @Autowired
    private SweetIntegralActivityDrawMapper drawMapper;

    @Override
    public ResponseDto<List<IntegralActivityVo>> getList() {
        List<IntegralActivityVo> integralActivityList = redisDataUtils.getIntegralActivityList();
        ArrayList<IntegralActivityVo> sweetIntegralActivityVoList = ObjectUtil.getSweetIntegralActivityVoList();
        for (IntegralActivityVo info : integralActivityList) {
            if (info.getIsOnline() == 1) {
                continue;
            }
            if (info.getTimeType() == 2) {
                LocalDateTime startTime = info.getStartTime();
                LocalDateTime endTime = info.getEndTime();
                LocalDateTime nowTime = LocalDateTime.now();
                if (nowTime.isAfter(endTime)) { // 已结束
                    continue;
                }
                if (startTime.isAfter(nowTime)) { // 未开始
                    continue;
                }
            }

            sweetIntegralActivityVoList.add(info);
        }
        return ResponseDto.success(sweetIntegralActivityVoList);
    }

    @Override
    public ResponseDto<IntegralActivityVo> detail(String integralActivityId) {
        IntegralActivityVo integralActivity = redisDataUtils.getIntegralActivityInfo(integralActivityId);
        integralActivity.setPrizeList1(null);
        integralActivity.setPrizeList2(null);
        List<IntegralActivityPrizeVo> prizeList = integralActivity.getPrizeList();
        if (!CollectionUtils.isEmpty(prizeList)) {
            prizeList.forEach(r -> {
                r.setPrizeNum(null);
                r.setWinningProbability(null);
                r.setPrizeRelationList(null);
                r.setCreatedAt(null);
                r.setUpdatedAt(null);
            });
        }
        return ResponseDto.success(integralActivity);
    }

    @Override
    public ResponseDto setDrawAllList() {
//        drawMapper.getStatList();
//        List<SweetAppletUser> sweetAppletUsers = sweetAppletUserMapper.selectList(Wrappers.lambdaQuery(SweetAppletUser.class).last("limit " + (page * size) + "," + ((page + 1) * size)));

        return ResponseDto.success();
    }
}
