package com.liquidnet.service.galaxy.dto.param;

import com.liquidnet.commons.lang.util.JsonUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyNftBuyResultQueryRespDto
 * @Package com.liquidnet.service.galaxy.dto.param
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/18 11:23
 */
@ApiModel(value = "GalaxyNftBuyResultQueryRespDto", description = "NFT购买结果查询")
@Data
public class GalaxyNftBuyResultQueryRespDto implements Serializable,Cloneable {

    @ApiModelProperty(position = 3, required = true, value = "标记任务状态，0：任务执行中 1：任务成功 2：任务失败")
    private Integer taskStatus;

    /**
     * 失败情况下会有提示信息
     */
    @ApiModelProperty(position = 3, required = true, value = "失败情况下会有提示信息")
    private String taskMsg;

    /**
     * 交易hash
     */
    @ApiModelProperty(position = 3, required = true, value = "交易hash")
    private String txHash;

    /**
     * 链上交易时间戳
     */
    @ApiModelProperty(position = 3, required = true, value = "chainTimestamp")
    private String chainTimestamp;

    @ApiModelProperty(position = 3, required = true, value = "支付任务ID")
    private String payTaskId;


    @Override
    public String toString() {
        return JsonUtils.toJson(this);
    }

    private static final GalaxyNftBuyResultQueryRespDto obj = new GalaxyNftBuyResultQueryRespDto();

    public static GalaxyNftBuyResultQueryRespDto getNew() {
        try {
            return (GalaxyNftBuyResultQueryRespDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyNftBuyResultQueryRespDto();
        }
    }
}
