package com.liquidnet.service.platform.controller.erp;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.service.IGoblinErpService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;


@Api(tags = "erp-旺店通")
@RestController
@RequestMapping("wdt")
@Validated
public class WdtController {

    @Autowired
    IGoblinErpService goblinErpService;

    @PostMapping("syncErpSpuStock")
    @ApiOperation("同步库存")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "spuId", value = "spuId"),
            @ApiImplicitParam(type = "form", required = true, dataType = "Integer", name = "min", value = "间隔时间"),
    })
    public ResponseDto<Boolean> initErpStock(@RequestParam("spuId") String spuId,
                                             @RequestParam("min") Integer min) {
        return goblinErpService.initErpStock(spuId,min);
    }

}
