package com.liquidnet.common.third.zxlnft.dto.nft;

import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 14.受信平台NFT身份绑定接口
 * @class: IdentityBindSubmitByTrustedReq
 * @Package com.liquidnet.common.third.zxlnft.dto.nft
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/2/18 15:30
 */
@Data
public class Nft014IdentityBindSubmitByTrustedReq implements Serializable {
    /**
     * 签名信息sign(用户唯一标识)
     */
    private String userSignData;
    /**
     * 用户公钥
     */
    private String userPubKey;
    /**
     * 平台公钥
     */
    private String platformPubKey;
    /**
     * 平台签名信息:sign(userSignData)
     */
    private String platformSignData;
    /**
     * 用户唯一标识
     */
    private String userIdentification;

    private static final Nft014IdentityBindSubmitByTrustedReq obj = new Nft014IdentityBindSubmitByTrustedReq();
    private static final long serialVersionUID = 952359226484874631L;

    public static Nft014IdentityBindSubmitByTrustedReq getNew() {
        try {
            return (Nft014IdentityBindSubmitByTrustedReq) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new Nft014IdentityBindSubmitByTrustedReq();
        }
    }
}
