package com.liquidnet.service.sweet.dto.param.admin;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * <p>
 * SweetIntegralActivityListSearchParam
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-10-20
 */

@Data
@ApiModel(value = "SweetYbActivityListParam", description = "yb活动列表")
public class SweetYbActivityListParam implements Serializable {

    private static final long serialVersionUID = 6917807562233084828L;

    @ApiModelProperty(position = 11, value = "标题")
    private String title;

    @ApiModelProperty(value = "开始时间")
    private String startTime;

    @ApiModelProperty(value = "结束时间")
    private String endTime;

    @ApiModelProperty(value = "页数", example = "0")
    @NotNull(message = "页数不能为空")
    private Integer pageSize;

    @ApiModelProperty(value = "数量", example = "20")
    @NotNull(message = "数量不能为空")
    private Integer pageNum;

}
