package com.liquidnet.service.adam.dto.vo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.base.ResponseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;

@ApiModel(value = "AdamUserMemberVo", description = "会员用户信息")
@Data
public class AdamUserMemberVo implements Serializable, Cloneable {
    private static final long serialVersionUID = 9027553500608702757L;
    @ApiModelProperty(position = 11, value = "用户ID")
    private String uid;
    @ApiModelProperty(position = 12, value = "会员类型ID")
    private String memberId;
    @ApiModelProperty(position = 13, value = "会员号")
    private String memberNo;
    @ApiModelProperty(position = 14, value = "用户会员状态[1-NORMAL,2-INVALID]")
    private Integer state;
    @ApiModelProperty(position = 15, value = "过期时间")
    private String expiryAt;
    @ApiModelProperty(position = 16, value = "创建时间")
    private String createdAt;
    @ApiModelProperty(position = 17, value = "更新时间")
    private String updatedAt;

    private static final AdamUserMemberVo obj = new AdamUserMemberVo();

    public static AdamUserMemberVo getNew() {
        try {
            return (AdamUserMemberVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new AdamUserMemberVo();
        }
    }

    /**
     * 会员是否有效
     *
     * @return true-有效
     */
    @JsonIgnore
    public boolean isActive() {
        LocalDateTime expiryAt = DateUtil.Formatter.yyyyMMddHHmmss.parse(this.getExpiryAt());

        return this.getState() == 1 && null != expiryAt && expiryAt.isAfter(LocalDateTime.now());
    }
}
