package com.liquidnet.service.goblin.dto.manage;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


@ApiModel(value = "GoblinStorePurchaseParam")
@Data
public class GoblinStorePurchaseParam {

    @ApiModelProperty(required = false, value = "活动id[添加操作不需要]", example = "1")
    private String marketId;

    @ApiModelProperty(required = true, value = "商铺id", example = "活动名称")
    private String storeId;

    @ApiModelProperty(required = true, value = "活动名称", example = "活动名称")
    private String name;

    @ApiModelProperty(required = true, value = "活动开始时间", example = "2021-12-11 12:00:00")
    private String startTime;

    @ApiModelProperty(required = true, value = "活动结束时间", example = "2021-12-12 12:00:00")
    private String endTime;

    @ApiModelProperty(required = true, value = "是否预热", example = "0")
    private Integer isPre;

    @ApiModelProperty(required = false, value = "预热时间(不能早于开始时间7天)[开启预热必填]", example = "2021-12-10 12:00:00")
    private String preTime;
}
