package com.liquidnet.common.third.xuper.dto;

import lombok.Data;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 授予数字商品碎片
 * @class: Xuper001GetStokenReqDto
 * @Package com.liquidnet.common.third.xuper.dto
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/4/18 15:10
 */
@Data
public class Xuper007GrantShardReqDto {
    /**
     * 资产id
     */
    private Long assetId;
    /**
     * 资产创建者助记词
     */
    private String mnemonic;
    /**
     * 资产碎片id，需要确保asset下唯一，可以使用有序编号，也可以使用随机整数，默认使用sdk提供GenRandId方法生成
     */
    private Long shardId;
    /**
     * 资产接收者区块链地址
     */
    private String toAddr;
    /**
     * （可选）资产接收者用户id
     */
    private Long toUserId;
    /**
     * (可选)碎片价格
     */
    private Long price;

    private static final Xuper007GrantShardReqDto obj = new Xuper007GrantShardReqDto();
    public static Xuper007GrantShardReqDto getNew() {
        try {
            return (Xuper007GrantShardReqDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new Xuper007GrantShardReqDto();
        }
    }
}
