package com.liquidnet.service.consumer.kylin.config;

import com.liquidnet.common.cache.redis.config.RedisStreamConfig;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.consumer.kylin.receiver.ConsumerGoblinSqlCouponRdsReceiver;
import com.liquidnet.service.consumer.kylin.receiver.ConsumerGoblinSqlGoodsRdsReceiver;
import com.liquidnet.service.consumer.kylin.receiver.ConsumerGoblinSqlStoreRdsReceiver;
import lombok.var;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.stream.StreamMessageListenerContainer;
import org.springframework.data.redis.stream.Subscription;

import java.time.Duration;

@Configuration
public class ConsumerGoblinSqlUstoreRedisStreamConfig extends RedisStreamConfig {
    @Autowired
    ConsumerGoblinSqlStoreRdsReceiver consumerGoblinSqlStoreRdsReceiver;
    @Autowired
    ConsumerGoblinSqlGoodsRdsReceiver consumerGoblinSqlGoodsRdsReceiver;
    @Autowired
    ConsumerGoblinSqlCouponRdsReceiver consumerGoblinSqlCouponRdsReceiver;

    /**
     * 店铺相关
     *
     * @param listenerContainer StreamMessageListenerContainer
     * @param t                 消费者序号
     * @return Subscription
     */
    private Subscription receiveSqlStore(StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer, int t) {
        return listenerContainer.receiveAutoAck(Consumer.from(MQConst.GoblinQueue.SQL_STORE.getGroup(), getConsumerName(MQConst.GoblinQueue.SQL_STORE.name() + t)),
                StreamOffset.create(MQConst.GoblinQueue.SQL_STORE.getKey(), ReadOffset.lastConsumed()), consumerGoblinSqlStoreRdsReceiver);
    }

    /**
     * 商品相关
     *
     * @param listenerContainer StreamMessageListenerContainer
     * @param t                 消费者序号
     * @return Subscription
     */
    private Subscription receiveSqlGoods(StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer, int t) {
        return listenerContainer.receiveAutoAck(Consumer.from(MQConst.GoblinQueue.SQL_GOODS.getGroup(), getConsumerName(MQConst.GoblinQueue.SQL_GOODS.name() + t)),
                StreamOffset.create(MQConst.GoblinQueue.SQL_GOODS.getKey(), ReadOffset.lastConsumed()), consumerGoblinSqlGoodsRdsReceiver);
    }

    /**
     * 店铺优惠券相关
     *
     * @param listenerContainer StreamMessageListenerContainer
     * @param t                 消费者序号
     * @return Subscription
     */
    private Subscription receiveSqlCoupon(StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer, int t) {
        return listenerContainer.receiveAutoAck(Consumer.from(MQConst.GoblinQueue.SQL_COUPON.getGroup(), getConsumerName(MQConst.GoblinQueue.SQL_COUPON.name() + t)),
                StreamOffset.create(MQConst.GoblinQueue.SQL_COUPON.getKey(), ReadOffset.lastConsumed()), consumerGoblinSqlCouponRdsReceiver);
    }

    /* —————————————————————————— ｜ —————————————————————————— ｜ —————————————————————————— */

    /* -------------------------------------------------------- ｜ 店铺相关 */

    @Bean
    public Subscription subscriptionSqlStore0(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlStore(listenerContainer, 0);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionSqlStore1(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlStore(listenerContainer, 1);
        listenerContainer.start();
        return subscription;
    }

    /* -------------------------------------------------------- ｜ 用户中心 */

    @Bean
    public Subscription subscriptionSqlGoods0(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlGoods(listenerContainer, 0);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionSqlGoods1(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlGoods(listenerContainer, 1);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionSqlGoods2(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlGoods(listenerContainer, 2);
        listenerContainer.start();
        return subscription;
    }

    /* -------------------------------------------------------- ｜ 店铺优惠券相关 */

    @Bean
    public Subscription subscriptionSqlCoupon0(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlCoupon(listenerContainer, 0);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionSqlCoupon1(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlCoupon(listenerContainer, 1);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionSqlCoupon2(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlCoupon(listenerContainer, 2);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionSqlCoupon3(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlCoupon(listenerContainer, 3);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionSqlCoupon4(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlCoupon(listenerContainer, 4);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionSqlCoupon5(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlCoupon(listenerContainer, 5);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionSqlCoupon6(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlCoupon(listenerContainer, 6);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionSqlCoupon7(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlCoupon(listenerContainer, 7);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionSqlCoupon8(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlCoupon(listenerContainer, 8);
        listenerContainer.start();
        return subscription;
    }

    @Bean
    public Subscription subscriptionSqlCoupon9(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveSqlCoupon(listenerContainer, 9);
        listenerContainer.start();
        return subscription;
    }

    /* -------------------------------------------------------- ｜  */
}
