package com.liquidnet.client.admin.web.controller.zhengzai.adam;

import com.liquidnet.client.admin.zhengzai.adam.service.IAdamMemberAdminService;
import com.liquidnet.client.admin.zhengzai.adam.service.IAdamMemberCodeAdminService;
import com.liquidnet.service.adam.dto.AdamMemberCodeParam;
import com.liquidnet.service.adam.dto.AdamMemberParam;
import com.liquidnet.service.adam.dto.vo.AdamMemberVo;
import com.liquidnet.service.adam.entity.AdamMember;
import com.liquidnet.service.base.ResponseDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

@Api(tags = "后台管理:会员信息")
@Slf4j
@Validated
@RestController
@RequestMapping("/admin/member")
public class AdamMemberAdminController {
    @Autowired
    IAdamMemberAdminService adamMemberService;
    @Autowired
    IAdamMemberCodeAdminService adamMemberCodeAdminService;

    @ApiOperation(value = "添加会员卡")
    @PostMapping("add")
    public ResponseDto<Object> add(@RequestBody AdamMemberParam parameter) {
        return ResponseDto.success(adamMemberService.add(parameter));
    }

    @ApiOperation(value = "会员卡列表")
    @PostMapping("list")
    public ResponseDto<List<AdamMemberVo>> list() {
        List<AdamMember> list = adamMemberService.list();
        List<AdamMemberVo> vos = new ArrayList<>();
        list.forEach(r -> {
            vos.add(AdamMemberVo.getNew().copy(r));
        });
        return ResponseDto.success(vos);
    }

    @ApiOperation(value = "同步会员卡")
    @PostMapping("sync")
    public ResponseDto<Object> sync() {
        return adamMemberService.sync();
    }

    @PostMapping("gen_code")
    public ResponseDto<String> genMemberCode(@RequestBody AdamMemberCodeParam parameter) {
        return ResponseDto.success(adamMemberCodeAdminService.createGiftCode(parameter));
    }
}
