package com.liquidnet.service.adam.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 会员权益配置
 * </p>
 *
 * @author liquidnet
 * @since 2021-08-25
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class AdamMemberRights implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    private String mrightsId;

    /**
     * 会员类型id
     */
    private String memberId;

    /**
     * 发放状态[0-INIT|1-NORMAL|2-INVALID]
     */
    private Integer state;

    /**
     * 排列序号
     */
    private Integer seqNo;

    /**
     * 权益标题
     */
    private String title;

    /**
     * 副标题
     */
    private String subTitle;

    /**
     * 标注
     */
    private String label;

    /**
     * 图片标识
     */
    private String cover;

    /**
     * 详情内容
     */
    private String detail;

    private String comment;


}
