package com.liquidnet.service.kylin.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.liquidnet.commons.lang.util.HttpUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.commons.lang.util.MD5;
import com.liquidnet.service.kylin.dto.vo.middle.message.MessageConfigVo;
import com.liquidnet.service.kylin.dto.vo.middle.message.MessageDataVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.time.LocalDateTime;

@Service
@Slf4j
public class OtherUtils {

    @Value("${liquidnet.url-service.url}")
    private String serviceUrl;

    //发短信
    public boolean sendMessage(String mobile, MessageDataVo data, MessageConfigVo configVo, Integer sign_id) {
        try {
            if (null != configVo && null != configVo.getStatus() && configVo.getStatus()) {
                LinkedMultiValueMap<String, String> httpData = new LinkedMultiValueMap<>();
                httpData.add("mobile", mobile);
                httpData.add("templateId", configVo.getId());
                httpData.add("signId", sign_id.toString());
                httpData.add("data", JsonUtils.toJson(data));
                String sign = Ksort(httpData);
                sign = sign.concat("&key=").concat("R7tXY9smPQPG9Ku5yI0u6sfnlckmk04V");
                sign = sign.toUpperCase();
                httpData.add("sign", sign);

                System.out.println("data = = = "+httpData.toString());

                String returnData = HttpUtil.post(serviceUrl + "sendSmsMessage", httpData);
                JsonNode postResultNew = JsonUtils.fromJson(returnData, JsonNode.class);
                if (!postResultNew.get("message").toString().equals("OK")) {
                    return false;
                } else {
                    return true;
                }
            } else {
                return false;
            }
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public String Ksort(MultiValueMap<String, String> map) {
        String sb = "";
        String[] key = new String[map.size()];
        int index = 0;
        for (String k : map.keySet()) {
            key[index] = k;
            index++;
        }
        for (String s : key) {
            sb += s + "=" + map.get(s).get(0) + "&";
        }
        sb = sb.substring(0, sb.length() - 1);
        // 将得到的字符串进行处理得到目标格式的字符串
        try {
            sb = URLDecoder.decode(sb, "UTF-8");
        } catch (UnsupportedEncodingException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }// 使用常见的UTF-8编码
        sb = sb.replace("%3D", "=").replace("%26", "&");
        return sb;
    }

    public static String md5s(String txt) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(txt.getBytes("GBK"));    //问题主要出在这里，Java的字符串是unicode编码，不受源码文件的编码影响；而PHP的编码是和源码文件的编码一致，受源码编码影响。
            StringBuilder buf = new StringBuilder();
            for (byte b : md.digest()) {
                buf.append(String.format("%02x", b & 0xff));
            }
            return buf.toString();
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}
