package com.liquidnet.service.adam.service.impl;

import com.github.pagehelper.PageInfo;
import com.liquidnet.common.mq.constant.MQConst;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.adam.dto.vo.AdamCollectInfoVo;
import com.liquidnet.service.adam.dto.vo.AdamDisposedBaseVo;
import com.liquidnet.service.adam.dto.vo.AdamDisposedUserVo;
import com.liquidnet.service.adam.dto.vo.AdamDisposedVo;
import com.liquidnet.service.adam.service.IAdamDisposedService;
import com.liquidnet.service.adam.service.IAdamRdmService;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.feign.kylin.api.FeignKylinPerformanceClient;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinPerformanceVo;
import com.mongodb.client.result.UpdateResult;
import lombok.extern.slf4j.Slf4j;
import org.bson.Document;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.LinkedList;
import java.util.List;

/**
 * <p>
 * 想去 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-18
 */
@Slf4j
@Service
public class AdamDisposedServiceImpl implements IAdamDisposedService {
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    RabbitTemplate rabbitTemplate;
    @Autowired
    IAdamRdmService adamRdmService;


    /* ---------------- 外部服务API ---------------- */
    @Autowired
    FeignKylinPerformanceClient kylinPerformanceClient;

    @Override
    public void add(AdamDisposedBaseVo vo) {
        LocalDateTime now = LocalDateTime.now();

        vo.setState(1);
        vo.setCreatedAt(now);

        mongoTemplate.insert(vo, AdamDisposedBaseVo.class.getSimpleName());

        rabbitTemplate.convertAndSend(MQConst.EX_LNS_SQL_UCENTER, MQConst.RK_SQL_UCENTER,
                SqlMapping.get("adam_disposed.add",
                        vo.getUid(), vo.getContentId(), vo.getType(), vo.getState(), now
                )
        );
    }

    @Override
    public AdamDisposedBaseVo query(String uid, String type, String contentId) {
        return mongoTemplate.findOne(Query.query(Criteria.where("uid").is(uid).and("type").is(type)
                        .and("contentId").is(contentId).and("state").is(1)),
                AdamDisposedBaseVo.class, AdamDisposedBaseVo.class.getSimpleName());
    }

    @Override
    public void del(String uid, String type, String... contentIds) {
        LocalDateTime now = LocalDateTime.now();
        String nowStr = DateUtil.format(now, DateUtil.Formatter.yyyyMMddHHmmss);

//        AdamDisposedBaseVo delVo = AdamDisposedBaseVo.getNew();
//        delVo.setState(2);
//        delVo.setUpdatedAt(now);

        UpdateResult updateResult = mongoTemplate.getCollection(AdamDisposedBaseVo.class.getSimpleName()).updateMany(
                Query.query(Criteria.where("uid").is(uid).and("type").is(type)
                        .and("contentId").in(contentIds).and("state").is(1)).getQueryObject(),
                new Document("$set", new Document("state", 2).append("updatedAt", now)));
        if (updateResult.getModifiedCount() > 0) {
            LinkedList<Object[]> toMqObjs = new LinkedList<>();
            for (String c : contentIds) {
                toMqObjs.add(new Object[]{now, uid, c});
            }
            rabbitTemplate.convertAndSend(MQConst.EX_LNS_SQL_UCENTER, MQConst.RK_SQL_UCENTER,
                    SqlMapping.get("adam_disposed.del", toMqObjs));
        }
    }

    @Override
    public boolean queryState(String uid, String type, String contentId) {
        long count = mongoTemplate.count(Query.query(Criteria.where("uid").is(uid).and("type").is(type)
                .and("contentId").is(contentId).and("state").is(1)), AdamDisposedBaseVo.class.getSimpleName());
        return count > 0;
    }

    @Override
    public PageInfo<AdamDisposedVo> queryPage(String uid, String type, int pageNo, int pageSize) {
        Query query = Query.query(Criteria.where("uid").is(uid).and("type").is(type).and("state").is(1));

        long count = mongoTemplate.count(query, AdamDisposedBaseVo.class.getSimpleName());

        PageInfo<AdamDisposedVo> voPageInfo = null;
        if (count > 0) {
            query.with(PageRequest.of(pageNo - 1, pageSize, Sort.by(Sort.Direction.DESC, "createdAt")));

            List<AdamDisposedVo> disposedVoList = mongoTemplate.find(query, AdamDisposedVo.class, AdamDisposedBaseVo.class.getSimpleName());

            if (!CollectionUtils.isEmpty(disposedVoList)) {
                List<KylinPerformanceVo> kylinPerformanceVoList = null;
                try {
                    String[] contentIds = disposedVoList.stream().map(AdamDisposedVo::getContentId).toArray(a -> new String[disposedVoList.size()]);

                    ResponseDto<List<KylinPerformanceVo>> performanceVoListDto = kylinPerformanceClient.performanceList(contentIds);

                    if (performanceVoListDto.isSuccess()) {
                        kylinPerformanceVoList = performanceVoListDto.getData();
                    } else {
                        log.info("Failed:{}.API.performanceList(...) for AdamDisposedVo:{}", kylinPerformanceClient.getClass().getSimpleName(), performanceVoListDto.toJson());
                    }
                } catch (Exception e) {
                    log.error("Exception:{}.API.performanceList(...) for AdamDisposedVo >> {}", kylinPerformanceClient.getClass().getSimpleName(), e.getLocalizedMessage());
                }

                if (!CollectionUtils.isEmpty(kylinPerformanceVoList)) {
                    kylinPerformanceVoList.forEach(pv -> {
                        disposedVoList.forEach(v -> {
                            if (pv.getPerformancesId().equals(v.getContentId())) {
                                AdamCollectInfoVo collectInfoVo = AdamCollectInfoVo.getNew();
                                BeanUtils.copyProperties(pv, collectInfoVo);
                                v.setContentInfo(collectInfoVo);
                            }

                            PageInfo<AdamDisposedUserVo> disposedUserVoPageInfo = this.queryDisposedUsers(type, v.getContentId(), 1, 3);

                            if (disposedUserVoPageInfo.getTotal() > 0) v.setUserVos(disposedUserVoPageInfo.getList());
                        });
                    });
                } else {
                    disposedVoList.forEach(v -> {
                        PageInfo<AdamDisposedUserVo> disposedUserVoPageInfo = this.queryDisposedUsers(type, v.getContentId(), 1, 3);

                        if (disposedUserVoPageInfo.getTotal() > 0) v.setUserVos(disposedUserVoPageInfo.getList());
                    });
                }
            }

            voPageInfo = PageInfo.of(disposedVoList);
            voPageInfo.setTotal(count);
        } else {
            voPageInfo = new PageInfo<>();
        }

        return voPageInfo;
    }

    @Override
    public PageInfo<AdamDisposedUserVo> queryDisposedUsers(String type, String contentId, int pageNo, int pageSize) {
        Query query = Query.query(Criteria.where("type").is(type).and("contentId").is(contentId).and("state").is(1));

        long count = mongoTemplate.count(query, AdamDisposedBaseVo.class.getSimpleName());

        PageInfo<AdamDisposedUserVo> voPageInfo = null;
        if (count > 0) {
            query.with(PageRequest.of(pageNo - 1, pageSize, Sort.by(Sort.Direction.DESC, "createdAt")));

            List<AdamDisposedUserVo> disposedUserVoList = mongoTemplate.find(query, AdamDisposedUserVo.class, AdamDisposedBaseVo.class.getSimpleName());

            voPageInfo = PageInfo.of(disposedUserVoList);
            voPageInfo.setTotal(count);
        } else {
            voPageInfo = new PageInfo<>();
        }
        return voPageInfo;
    }
}
