package com.liquidnet.service.goblin.test;

import com.liquidnet.common.cache.redis.util.RedisDataSourceUtil;
import com.liquidnet.commons.lang.util.CollectionUtil;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.data.redis.connection.stream.StreamRecords;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import java.util.HashMap;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: TestResisQueue
 * @Package com.liquidnet.service.goblin.test
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/6/14 15:42
 */
@Slf4j
@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest
public class TestResisQueue {
    @Autowired
    private RedisDataSourceUtil redisDataSourceUtil;

    @Autowired
    StringRedisTemplate stringRedisTemplate;

    /**
     * 兼容测试
     */
    @Test
    public void oldPringRedisInitInfo(){
        redisDataSourceUtil.getRedisKylinUtil().set("testNldRedis","12345");
        redisDataSourceUtil.getRedisKylinUtil().set("testoldRedis","12345");
        System.out.println("getRedisKylinUtil.get==="+ redisDataSourceUtil.getRedisKylinUtil().get("testoldRedis"));
        System.out.println("getRedisDragonUtil.totalDbs==="+ redisDataSourceUtil.getRedisDragonUtil().getDbs());
    }

    /**
     * 兼容测试队列
     */
    @Test
    public void oldGetRedisQueue(){
        String json = "{\n" +
                "  \"nftOrderPayId\": \"1234567890-order-022-008\",\n" +
                "  \"routerType\": \"zxinchain\",\n" +
                "  \"skuId\": \"1234567890-sku-022\",\n" +
                "  \"userId\": \"123456789-user-002\",\n" +
                "  \"buyTimestamp\":\"2022-04-12 13:50:12\"\n" +
                "}";
        HashMap<String, String> map = CollectionUtil.mapStringString();
        map.put("message", json);
        log.info("stringRedisTemplate.stream===",stringRedisTemplate.opsForStream().add(StreamRecords.mapBacked(map).withStreamKey("goblintest_old:stream:dragon-pay")));

        json = "{\n" +
                "  \"nftOrderPayId\": \"1234567890-queue-022-008\",\n" +
                "  \"routerType\": \"zxinchain\",\n" +
                "  \"skuId\": \"1234567890-sku-022\",\n" +
                "  \"userId\": \"123456789-user-002\",\n" +
                "  \"buyTimestamp\":\"2022-04-12 13:50:12\"\n" +
                "}";
        map.put("message", json);
        log.info("getRedisQueueUtil.stream===",redisDataSourceUtil.getRedisQueueUtil().getStringRedisTemplate().opsForStream().add(StreamRecords.mapBacked(map).withStreamKey("goblintest_new:stream:dragon-pay")));

//        log.info("getRedisKylinUtil.stream===",redisDataSourceUtil.getRedisKylinUtil().getStringRedisTemplate().opsForStream().size("dragon:stream:dragon-pay"));
//        log.info("getRedisDragonUtil.stream===",redisDataSourceUtil.getRedisDragonUtil().getStringRedisTemplate().opsForStream().size("dragon:stream:dragon-pay"));
//        log.info("getRedisSweetUtil.stream===",redisDataSourceUtil.getRedisSweetUtil().getStringRedisTemplate().opsForStream().size("abc"));
//        log.info("getRedisAdamUtil.stream===",redisDataSourceUtil.getRedisAdamUtil().getStringRedisTemplate().opsForStream().size("abc"));
//        log.info("getRedisCandyUtil.stream===",redisDataSourceUtil.getRedisCandyUtil().getStringRedisTemplate().opsForStream().size("abc"));
    }
}
