package com.liquidnet.service.goblin.dto.manage;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;
import java.util.List;

@ApiModel(value = "GoblinStorePurchaseItemParam")
@Data
public class GoblinStoreZhengzaiCommonSingleParam implements Cloneable {

    @ApiModelProperty(required = true, value = "spuId", example = "1")
    @NotBlank(message = "spuId不能空")
    private String spuId;
    @ApiModelProperty(required = true, value = "skuId", example = "1")
    @NotBlank(message = "skuId不能为空")
    private String skuId;

    private static final GoblinStoreZhengzaiCommonSingleParam obj = new GoblinStoreZhengzaiCommonSingleParam();

    public static GoblinStoreZhengzaiCommonSingleParam getNew() {
        try {
            return (GoblinStoreZhengzaiCommonSingleParam) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinStoreZhengzaiCommonSingleParam();
        }
    }
}



