package com.liquidnet.service.goblin.mapper;

import com.liquidnet.service.goblin.dto.GoblinSelfGoodsCategoryDto;
import com.liquidnet.service.goblin.entity.GoblinSelfGoodsCategory;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * <p>
 * 平台商品分类 Mapper 接口
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
public interface GoblinSelfGoodsCategoryMapper extends BaseMapper<GoblinSelfGoodsCategory> {
    // SELECT cf.cate_id AS cateFid, cf.name AS fname, cf.icon AS ficon, cf.ne_isbn AS fneIsbn, cf.counts AS fcounts , cs.cate_id AS cateSid, cs.name AS sname, cs.icon AS sicon, cs.ne_isbn AS sneIsbn, cs.counts AS scounts , ct.cate_id AS cateTid, ct.name AS tname, ct.icon AS ticon, ct.ne_isbn AS tneIsbn, ct.counts AS tcounts FROM goblin_self_goods_category cf LEFT JOIN ( SELECT cate_id, name, icon, grade, ne_isbn , counts, cate_pid FROM goblin_self_goods_category WHERE grade = '2' AND del_flg = '0' ) cs ON cs.cate_pid = cf.cate_id LEFT JOIN ( SELECT cate_id, name, icon, grade, ne_isbn , counts, cate_pid FROM goblin_self_goods_category WHERE grade = '3' AND del_flg = '0' ) ct ON ct.cate_pid = cs.cate_id WHERE cf.grade = '1' AND del_flg = '0'
    @Select({"select cf.cate_id cateFid,\n" +
            "       cf.name    fname,\n" +
            "       cf.icon    ficon,\n" +
            "       cf.ne_isbn fneIsbn,\n" +
            "       cf.counts  fcounts,\n" +
            "       cs.cate_id cateSid,\n" +
            "       cs.name    sname,\n" +
            "       cs.icon    sicon,\n" +
            "       cs.ne_isbn sneIsbn,\n" +
            "       cs.counts  scounts,\n" +
            "       ct.cate_id cateTid,\n" +
            "       ct.name    tname,\n" +
            "       ct.icon    ticon,\n" +
            "       ct.ne_isbn tneIsbn,\n" +
            "       ct.counts  tcounts\n" +
            "from goblin_self_goods_category cf\n" +
            "         left join (\n" +
            "    select cate_id, name, icon, grade, ne_isbn, counts, cate_pid from goblin_self_goods_category where grade = '2' and del_flg = '0'\n" +
            ") cs on cs.cate_pid = cf.cate_id\n" +
            "         left join (\n" +
            "    select cate_id, name, icon, grade, ne_isbn, counts, cate_pid from goblin_self_goods_category where grade = '3' and del_flg = '0'\n" +
            ") ct on ct.cate_pid = cs.cate_id\n" +
            "where cf.grade = '1' and del_flg = '0'"})
    List<GoblinSelfGoodsCategoryDto> listForForMultiGrade();
}
