package com.liquidnet.service.goblin.entity;

import java.math.BigDecimal;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;

import java.time.LocalDateTime;
import java.io.Serializable;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 商品信息
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinGoods implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 商品id
     */
    private String spuId;

    /**
     * 商品编码
     */
    private String spuNo;

    /**
     * 商品名称
     */
    private String name;

    /**
     * 商品副标题
     */
    private String subtitle;

    /**
     * 销售价-原价
     */
    private BigDecimal sellPrice;

    /**
     * 价格区间MIN
     */
    private BigDecimal priceGe;

    /**
     * 价格区间MAX
     */
    private BigDecimal priceLe;

    /**
     * 商品简介
     */
    private String intro;

    /**
     * 详情
     */
    private String details;

    /**
     * 封面图片地址
     */
    private String coverPic;

    /**
     * 商品视频地址
     */
    private String video;

    /**
     * 规格展现方式[1-常规|2-组合]
     */
    private String specMode;

    /**
     * 商品的店铺id，如果是平台的则为0
     */
    private String storeId;

    /**
     * 平台一级分类id
     */
    private String cateFid;

    /**
     * 平台二级分类id
     */
    private String cateSid;

    /**
     * 平台三级分类id
     */
    private String cateTid;

    /**
     * 店铺一级分类id
     */
    private String storeCateFid;

    /**
     * 店铺二级分类id
     */
    private String storeCateSid;

    /**
     * 店铺三级分类id
     */
    private String storeCateTid;

    /**
     * 品牌id
     */
    private String brandId;

    /**
     * 上架处理方式[1-等待手动上架|2-直接上架售卖|3-预约定时上架]
     */
    private String shelvesHandle;

    /**
     * 上架处理方式为3-预约定时上架时需要指定]
     */
    private LocalDateTime shelvesTime;

    /**
     * 商品有效期
     */
    private LocalDateTime spuValidity;

    /**
     * 是否虚拟商品[0-否|1-是]
     */
    private String virtualFlg;

    /**
     * 审核状态[0-编辑中|1-审核中|2-审核不通过|3-审核通过]
     */
    private String status;

    /**
     * 审核拒绝原因
     */
    private String reason;

    /**
     * 商品上架状态[0-待上架|1-下架|2-违规|3-上架]
     */
    private String shelvesStatus;

    /**
     * 自定义展示[0-默认展示|1-隐藏不可购买]
     */
    private String spuAppear;

    /**
     * 删除标记[0-未删除|1-删除]
     */
    private String delFlg;

    /**
     * 上架时间
     */
    private LocalDateTime shelvesAt;

    private String createdBy;

    private LocalDateTime createdAt;

    private String updatedBy;

    private LocalDateTime updatedAt;

    private String deletedBy;

    private LocalDateTime deletedAt;

    /**
     * 物流模版id
     */
    private String logisticsTemplate;

    private String comment;


}
