package com.liquidnet.service.candy.util;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.candy.constant.CandyRedisConst;
import com.liquidnet.service.candy.dto.CandyUserCouponBasicDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

@Component
public class RedisDataUtils {

    @Autowired
    RedisUtil redisUtil;

    public List<CandyUserCouponBasicDto> getCouponByUid(String uid){
        String redisKey = CandyRedisConst.BASIC_USER_COUPON.concat(uid);
        Object obj = redisUtil.get(redisKey);
        if(obj==null){
            //降级
            return new ArrayList();
        }else{
            return (List<CandyUserCouponBasicDto>)obj;
        }
    }

    public void setCouponByUid(String uid,List<CandyUserCouponBasicDto> dtoList){
        String redisKey = CandyRedisConst.BASIC_USER_COUPON.concat(uid);
        redisUtil.set(redisKey,dtoList);
    }
}
