package com.liquidnet.common.third.zxlnft.config;

import com.liquidnet.commons.lang.util.BASE64Util;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

import java.io.UnsupportedEncodingException;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: EasemobConfig
 * @Package com.liquidnet.common.third.easemob.config
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/9/7 10:42
 */
@Configuration
public class ZxlnftConfig {
    @Value("${liquidnet.zxlnft.appId:220214000100001}")
    private String appId;
    @Value("${liquidnet.zxlnft.appKey:82b561110c4b4f4d91ad2a2b0d5b7908}")
    private String appKey;
    @Value("${liquidnet.zxlnft.nftPlatformAddress:ZXa66c8a684727d0f9aaa434044362aa8a18b61bb4}")
    private String nftPlatformAddress;
    @Value("${liquidnet.zxlnft.nftPlatformPubKey:LS0tLS1CRUdJTiBQVUJMSUMgS0VZLS0tLS0KTUZrd0V3WUhLb1pJemowQ0FRWUlLb0VjejFVQmdpMERRZ0FFbFNTQk00MHJIZlJFa0NjWUxlRm1RZzE0SHlIcAp5Rk9uSktzblFqbDBCL2JXOStFWnZPblArNW0vMEdkUCtXM29yeG5Kd3p5OHNoYS9OYkQ4QVBmNXlBPT0KLS0tLS1FTkQgUFVCTElDIEtFWS0tLS0tCg==}")
    private String nftPlatformPubKey;
    @Value("${liquidnet.zxlnft.nftPlatformPriKey:LS0tLS1CRUdJTiBQUklWQVRFIEtFWS0tLS0tCk1JR1RBZ0VBTUJNR0J5cUdTTTQ5QWdFR0NDcUJITTlWQVlJdEJIa3dkd0lCQVFRZ1VhbTVWM2V6ZFZJTmNoZ28KVDRKL28zMHArMGJCd3hQWUZFL01FdEU3MTZhZ0NnWUlLb0VjejFVQmdpMmhSQU5DQUFTVkpJRXpqU3NkOUVTUQpKeGd0NFdaQ0RYZ2ZJZW5JVTZja3F5ZENPWFFIOXRiMzRSbTg2Yy83bWIvUVowLzViZWl2R2NuRFBMeXlGcjgxCnNQd0E5L25JCi0tLS0tRU5EIFBSSVZBVEUgS0VZLS0tLS0K}")
    private String nftPlatformPriKey;
    @Value("${liquidnet.zxlnft.walletSdkUrl:http://127.0.0.1:30505}")
    private String walletSdkUrl;
    @Value("${liquidnet.zxlnft.nftApiUrl:https://nfttest2.zxinchain.com}")
    private String nftApiUrl;

    @Value("${liquidnet.zxlnft.platformIdentification:4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef}")
    private String platformIdentification;

    public String getAppId(){
        return appId;
    }

    public String getAppKey() {
        return appKey;
    }

    public String getNftPlatformAddress() {
        return nftPlatformAddress;
    }

    public String getPlatformIdentification() {
        return platformIdentification;
    }

    //    public String getNftPlatformPubKey(){
//        return nftPlatformPubKey;
//    }
//
//    public String getNftPlatformPriKey(){
//        return nftPlatformPriKey;
//    }

    public String getNftPlatformPubKey(){
        String pubKey = null;
        try {
            pubKey = BASE64Util.decode(nftPlatformPubKey);
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return pubKey;
    }

    public String getNftPlatformPriKey(){
        String priKey = null;
        try {
            priKey = BASE64Util.decode(nftPlatformPriKey);
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return priKey;
    }

    public String getWalletSdkUrl(){
        return walletSdkUrl;
    }

    public String getNftApiUrl(){
        return nftApiUrl;
    }

}

