package com.liquidnet.service.platform.controller.goblin.task;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.PlatformGoblinNftOrderNotPayDto;
import com.liquidnet.service.goblin.mapper.GoblinNftOrderMapper;
import com.liquidnet.service.platform.utils.GoblinRedisUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * NFT订单相关定时任务
 *
 * @author jiangxiulng
 */
@Api(tags = "NFT订单相关定时任务")
@Slf4j
@RestController
@RequestMapping("task/nft/order")
public class PlatformGoblinNftOrderController {
    @Autowired
    private GoblinNftOrderMapper goblinNftOrderMapper;
    @Autowired
    private GoblinRedisUtils goblinRedisUtils;

    @ApiOperation(value = "查询待支付订单数量")
    @GetMapping("notPayNum")
    public ResponseDto<String> getNotPayNum() {
        List<PlatformGoblinNftOrderNotPayDto> goblinNftOrderList = goblinNftOrderMapper.selectOrderList();
        for (PlatformGoblinNftOrderNotPayDto notPayDto : goblinNftOrderList) {
            goblinRedisUtils.setNotPayNum(notPayDto.getSkuId(), notPayDto.getListId(), notPayDto.getNotPayNum());
        }
        return ResponseDto.success("查询待支付订单完成");
    }
}
