package com.liquidnet.service.adam.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@ApiModel(value = "AdamUserInfoVo", description = "用户详情")
@Data
public class AdamUserInfoVo implements java.io.Serializable, Cloneable {
    private static final long serialVersionUID = 8479869354894030303L;
    @ApiModelProperty(position = 10, value = "用户ID[64]")
    private String uid;
    @ApiModelProperty(position = 11, value = "手机号[20]")
    private String mobile;
    @ApiModelProperty(position = 12, value = "昵称[32]")
    private String nickname;
    @ApiModelProperty(position = 13, value = "状态[1-正常,2-注销]")
    private Integer state;
    @ApiModelProperty(position = 14, value = "性别[32]")
    private AdamTagVo sex;
    @ApiModelProperty(position = 15, value = "生日[YYYY-MM-DD]")
    private String birthday;
    @ApiModelProperty(position = 16, value = "常住地/区域")
    private String area;
    @ApiModelProperty(position = 17, value = "个性签名")
    private String signature;
    @ApiModelProperty(position = 18, value = "头像")
    private String avatar;
    @ApiModelProperty(position = 19, value = "背景图")
    private String background;
    @ApiModelProperty(position = 20, value = "标签")
    private List<AdamTagParentVo> tagMe;
    @ApiModelProperty(position = 21, value = "注册时间")
    private String createAt;
    @ApiModelProperty(position = 22, value = "最近一次更新时间")
    private String updatedAt;
    @ApiModelProperty(position = 23, value = "注销时间")
    private String closedAt;
    @ApiModelProperty(position = 24, value = "是否完善信息[0-未完善,1-已完善]")
    private Integer isComplete;
//    @ApiModelProperty(position = 25, value = "")
//    private String rongCloudToken;

    private static final AdamUserInfoVo obj = new AdamUserInfoVo();

    public static AdamUserInfoVo getNew() {
        try {
            return (AdamUserInfoVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new AdamUserInfoVo();
    }
}
