package com.liquidnet.service.kylin.timerTask;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.kylin.constant.KylinRedisConst;
import com.liquidnet.service.kylin.dto.param.PerformanceParam;
import com.liquidnet.service.kylin.dto.vo.PerformanceVo;
import com.liquidnet.service.kylin.dto.vo.TicketTimesVo;
import com.liquidnet.service.kylin.dto.vo.TicketVo;
import com.liquidnet.service.kylin.dto.vo.partner.*;
import com.liquidnet.service.kylin.entity.*;
import com.liquidnet.service.kylin.mapper.*;
import com.liquidnet.service.kylin.service.impl.partner.KylinTicketTimesPartnerServiceImpl;
import com.liquidnet.service.kylin.service.impl.partner.KylinTicketsPartnerServiceImpl;
import com.mongodb.BasicDBObject;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReturnDocument;
import org.bson.Document;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

@Component
public class PerformanceVoTask {

    @Autowired
    private MongoTemplate mongoTemplate;

    @Autowired
    private MongoConverter mongoConverter;

    @Autowired
    private RedisUtil redisUtil;

    @Autowired
    private KylinPerformancesMapper performancesMapper;

    @Autowired
    private KylinPerformanceStatusMapper performanceStatusMapper;

    @Autowired
    private KylinPerformanceRelationsMapper performanceRelationsMapper;

    @Autowired
    private KylinTicketTimesPartnerServiceImpl ticketTimesPartnerService;

    @Autowired
    private KylinTicketsMapper ticketsMapper;

    @Autowired
    private KylinTicketStatusMapper ticketStatusMapper;

    @Autowired
    private KylinTicketRelationsMapper ticketRelationsMapper;

    @Autowired
    private KylinTicketTimesMapper ticketTimesMapper;

    @Autowired
    private KylinTicketTimeRelationMapper ticketTimeRelationMapper;

    @Autowired
    private KylinTicketsPartnerServiceImpl ticketsPartnerService;


    /**
     * 根据票状态判断 演出状态 票状态
     *
     * @param performanceSingleId
     */
    public void performanceVoStatus(String performanceSingleId) {

        LocalDateTime timeNow = LocalDateTime.now();
        List<String> performanceIdList = new ArrayList<>();

        if (performanceSingleId.isEmpty()) {
            List<PerformanceVo> PerformanceVoList = mongoTemplate.findAll(PerformanceVo.class);
            for (PerformanceVo performanceVoItem : PerformanceVoList) {
                performanceIdList.add(performanceVoItem.getPerformancesId());
            }
        } else {
            performanceIdList.add(performanceSingleId);
        }

        for (String performancesId : performanceIdList) {
            //场次
            List<TicketTimesVo> timesData = mongoTemplate.find(
                    Query.query(Criteria.where("performanceId").is(performancesId)),
                    TicketTimesVo.class, TicketTimesVo.class.getSimpleName()
            );
            //总循环次数
            int ticketCount = 0;
            //未开售次数
            int status9Count = 0;
            //售罄次数
            int status8Count = 0;
            //已结束次数
            int status10Count = 0;
            //缺票登记
            int isLackRegister = 0;
            //会员
            int isMember = 0;
            //专属
            int isExclusive = 0;
            //提前
            int isAdvance = 0;
            //优惠
            int isDiscount = 0;

            //演出数据
            HashMap<String, Object> mapPerformance = new HashMap<>();
            int appStatus = 6;
            for (TicketTimesVo ticketTimesVoItem : timesData) {
                //票
                List<TicketVo> ticketVoList = mongoTemplate.find(
                        Query.query(Criteria.where("timeId").is(ticketTimesVoItem.getTimeId())),
                        TicketVo.class, TicketVo.class.getSimpleName()
                );
                ticketCount += ticketVoList.size();
                for (TicketVo ticketVoItem : ticketVoList) {
                    //时间判断
                    LocalDateTime timeStart = LocalDateTime.parse(ticketVoItem.getMemberTimeStart(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
                    LocalDateTime timeEnd = LocalDateTime.parse(ticketVoItem.getTimeEnd(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
                    int status = 0;
                    if (timeStart.isAfter(timeNow)) {
                        //未开始
                        status = 9;
                        status9Count += 1;
                    } else if (timeEnd.isBefore(timeNow)) {
                        //结束
                        status = 10;
                        status10Count += 1;
                    } else {
                        //库存判断
                        int surplusGeneral = (int) redisUtil.hget(KylinRedisConst.PERFORMANCES_INVENTORY + ticketVoItem.getTicketsId(), KylinRedisConst.SURPLUS_GENERAL);

                        if (surplusGeneral > 0) {
                            status = 6;
                        } else {
                            status = 8;
                            status8Count += 1;
                        }
                    }
                    //修改票状态
                    HashMap<String, Object> mapTicket = new HashMap<>();
                    mapTicket.put("status", status);
                    BasicDBObject objectTicket = new BasicDBObject("$set", mongoConverter.convertToMongoType(mapTicket));
                    mongoTemplate.getCollection(TicketVo.class.getSimpleName()).updateOne(
                            Query.query(Criteria.where("ticketsId").is(ticketVoItem.getTicketsId())).getQueryObject(),
                            objectTicket
                    );
                    //演出状态
                    if (status == 6) {//单一票 可购买 则为可购买
                        appStatus = 6;
                    } else if (ticketCount == status8Count) {//全票售罄为售罄
                        appStatus = 8;
                    } else if (ticketCount == status9Count) {//全票未开始 为未开始
                        appStatus = 9;
                    } else if (ticketCount == status10Count) {//全票结束 为结束
                        appStatus = 10;
                    }


                    if (ticketVoItem.getIsMember() == 1) {
                        if (ticketVoItem.getMemberPrice().compareTo(ticketVoItem.getPrice()) != 0) {
                            isDiscount = 1;
                        }

                        if (!ticketVoItem.getTimeStart().equalsIgnoreCase(ticketVoItem.getMemberTimeStart())) {
                            isAdvance = 1;
                        }

                        if (ticketVoItem.getIsMember() == 1) {
                            isMember = 1;
                        }

                        if (ticketVoItem.getIsExclusive() == 1) {
                            isExclusive = 1;
                        }
                    }

                    if (ticketVoItem.getIsLackRegister() == 1) {
                        isLackRegister = 1;
                    }

                }
            }
            //修改演出状态
            mapPerformance.put("appStatus", appStatus);
            mapPerformance.put("isLackRegister", isLackRegister);
            mapPerformance.put("isExclusive", isExclusive);
            mapPerformance.put("isMember", isMember);
            mapPerformance.put("isAdvance", isAdvance);
            mapPerformance.put("isDiscount", isDiscount);
            BasicDBObject objectPerformance = new BasicDBObject("$set", mongoConverter.convertToMongoType(mapPerformance));
            mongoTemplate.getCollection(PerformanceVo.class.getSimpleName()).updateOne(
                    Query.query(Criteria.where("performancesId").is(performancesId)).getQueryObject(),
                    objectPerformance
            );
        }
    }


    /**
     * 生成 PerformanceCreatePartnerVo(用于审核第一次提交数据)
     *
     * @param performancesId
     * @return
     */
    public PerformanceMisVo getPerformanceMisVo(String performancesId) {
        PerformanceParam performanceData = mongoTemplate.findOne(Query.query(Criteria.where("performancesId").is(performancesId)), PerformanceParam.class, PerformanceParam.class.getSimpleName());
        List<TicketTimesPartnerVo> ticketTimesPartnerVos = ticketTimesPartnerService.getTimesMongoList(performancesId);
        List<TicketTimesTicketCreatePartnerVo> ticketTimesTicketCreatePartnerVoList = new ArrayList<TicketTimesTicketCreatePartnerVo>();

        ArrayList<BigDecimal> floatList = new ArrayList<>();
        ArrayList<String> StringList = new ArrayList<>();

        for (TicketTimesPartnerVo ticketTimes : ticketTimesPartnerVos) {
            TicketTimesTicketCreatePartnerVo ticketTimesTicketCreatePartnerVo = new TicketTimesTicketCreatePartnerVo();
            BeanUtils.copyProperties(ticketTimes, ticketTimesTicketCreatePartnerVo);
            List<TicketPartnerVo> ticketPartnerVos = ticketsPartnerService.getTicketMongoList(ticketTimes.getTicketTimesId());
            ticketTimesTicketCreatePartnerVo.setTicket(ticketPartnerVos);
            ticketTimesTicketCreatePartnerVoList.add(ticketTimesTicketCreatePartnerVo);
            for (TicketPartnerVo ticketPartnerVoItem : ticketPartnerVos) {
                floatList.add(ticketPartnerVoItem.getPrice());
                StringList.add(ticketPartnerVoItem.getTimeEnd());
            }
        }
        PerformanceMisVo performanceMisVo = new PerformanceMisVo();
        BeanUtils.copyProperties(performanceData, performanceMisVo);

        floatList.sort(Comparator.reverseOrder());
        StringList.sort(Comparator.naturalOrder());

        performanceMisVo.setPrice(floatList.get(0) + "起");
        performanceMisVo.setStopSellTime(StringList.get(0));
        performanceMisVo.setTicketTimes(ticketTimesTicketCreatePartnerVoList);

//        if (performanceMisVo.getStatus() != 0) {
//            performanceMisVo.setStatus(null);
//            performanceMisVo.setStatusSell(null);
//            performanceMisVo.setRejectTxt("");
//            performanceMisVo.setIsShow(1);
            performanceMisVo.setIsDistribution(0);
            performanceMisVo.setSyncAgent(0);
            performanceMisVo.setAuditStatus(0);
//        }

//        boolean exists = mongoTemplate.exists(Query.query(Criteria.where("performancesId").is(performancesId)), PerformanceMisVo.class, PerformanceMisVo.class.getSimpleName());
//
//        if (!exists) {
//            PerformanceMisVo data = mongoTemplate.insert(
//                    performanceMisVo, PerformanceMisVo.class.getSimpleName()
//            );
//        }

        return performanceMisVo;
    }

//    /**
//     * 生成 PerformanceUpdatePartnerVo(用于修改审核提交数据)
//     *
//     * @param performancesId
//     * @return
//     */
//    public PerformanceMisVo setPerformanceUpdateParam(String performancesId) {
//        PerformanceParam performanceData = mongoTemplate.findOne(Query.query(Criteria.where("performancesId").is(performancesId)), PerformanceParam.class, PerformanceParam.class.getSimpleName());
//        List<TicketTimesPartnerVo> ticketTimesPartnerVos = ticketTimesPartnerService.getTimesMongoList(performancesId);
//        List<TicketTimesTicketCreatePartnerVo> ticketTimesTicketCreatePartnerVoList = new ArrayList<TicketTimesTicketCreatePartnerVo>();
//
//        ArrayList<BigDecimal> floatList = new ArrayList<>();
//        ArrayList<String> StringList = new ArrayList<>();
//
//        for (TicketTimesPartnerVo ticketTimes : ticketTimesPartnerVos) {
//            TicketTimesTicketCreatePartnerVo ticketTimesTicketCreatePartnerVo = new TicketTimesTicketCreatePartnerVo();
//            BeanUtils.copyProperties(ticketTimes, ticketTimesTicketCreatePartnerVo);
//            List<TicketPartnerVo> ticketPartnerVos = ticketsPartnerService.getTicketMongoList(ticketTimes.getTicketTimesId());
//            ticketTimesTicketCreatePartnerVo.setTicket(ticketPartnerVos);
//            ticketTimesTicketCreatePartnerVoList.add(ticketTimesTicketCreatePartnerVo);
//            for (TicketPartnerVo ticketPartnerVoItem : ticketPartnerVos) {
//                floatList.add(ticketPartnerVoItem.getPrice());
//                StringList.add(ticketPartnerVoItem.getTimeEnd());
//            }
//        }
//        PerformanceMisVo performanceMisVo = new PerformanceMisVo();
//        BeanUtils.copyProperties(performanceData, performanceMisVo);
//
//        floatList.sort(Comparator.reverseOrder());
//        StringList.sort(Comparator.naturalOrder());
//
//        performanceMisVo.setPrice(floatList.get(0) + "起");
//        performanceMisVo.setStopSellTime(StringList.get(0));
//        performanceMisVo.setTicketTimes(ticketTimesTicketCreatePartnerVoList);
//        performanceMisVo.setStatus(1);
//        performanceMisVo.setRejectTxt("");
//        performanceMisVo.setAuditStatus(0);
//        KylinPerformanceStatus performanceStatus = performanceStatusMapper.selectOne(new UpdateWrapper<KylinPerformanceStatus>().eq("performance_id", performancesId));
//        performanceMisVo.setStatusSell(performanceStatus.getStatusSell());
//        performanceMisVo.setIsShow(performanceStatus.getIsShow());
//        performanceMisVo.setIsDistribution(performanceStatus.getIsDistribution());
//        performanceMisVo.setSyncAgent(performanceStatus.getSyncAgent());
//
//
////        boolean exists = mongoTemplate.exists(Query.query(Criteria.where("performancesId").is(performancesId)), PerformanceMisVo.class, PerformanceMisVo.class.getSimpleName());
////
////        if (!exists) {
////            mongoTemplate.insert(
////                    performanceMisVo, PerformanceMisVo.class.getSimpleName()
////            );
////        } else {
////            BasicDBObject object = new BasicDBObject("$set", mongoConverter.convertToMongoType(performanceMisVo));
////            mongoTemplate.getCollection(PerformanceMisVo.class.getSimpleName()).updateOne(
////                    Query.query(Criteria.where("performancesId").is(performancesId)).getQueryObject(),
////                    object
////            );
////        }
//
//        return performanceMisVo;
//    }

    /**
     * 插入数据库
     *
     * @param performancesId
     * @param map
     * @param performanceMisVo
     * @param updatedAt
     */
    public void createPerformanceMySql(String performancesId, HashMap<String, Object> map, PerformanceMisVo performanceMisVo, LocalDateTime updatedAt) {
        try {
            //创建演出
            KylinPerformances performances = new KylinPerformances();
            BeanUtils.copyProperties(performanceMisVo, performances);
            KylinPerformanceStatus performanceStatus = new KylinPerformanceStatus();
            BeanUtils.copyProperties(performanceMisVo, performanceStatus);
            KylinPerformanceRelations performanceRelations = new KylinPerformanceRelations();
            BeanUtils.copyProperties(performanceMisVo, performanceRelations);

            performances.setCreatedAt(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(performanceMisVo.getCreatedAt())));
            performances.setTimeStart(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(performanceMisVo.getTimeStart())));
            performances.setTimeEnd(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(performanceMisVo.getTimeEnd())));
            performances.setUpdatedAt(updatedAt);

            performanceStatus.setPerformanceId(performances.getPerformancesId());
            performanceStatus.setPerformanceStatusId(IDGenerator.nextSnowId().toString());
            performanceStatus.setCreatedAt(performances.getCreatedAt());
            performanceStatus.setAuditStatus(0);
            performanceStatus.setUpdatedAt(updatedAt);

            performanceStatus.setLimitCountMember(1);

            performanceRelations.setPerformanceId(performances.getPerformancesId());
            performanceRelations.setPerformanceRelationsId(IDGenerator.nextSnowId().toString());
            performanceRelations.setCreatedAt(performances.getCreatedAt());
            performanceRelations.setUpdatedAt(updatedAt);

            performancesMapper.insert(performances);
            performanceStatusMapper.insert(performanceStatus);
            performanceRelationsMapper.insert(performanceRelations);


            //场次数据
            List<TicketTimesPartnerVo> ticketTimesPartnerVos = ticketTimesPartnerService.getTimesMongoList(performancesId);
            for (TicketTimesPartnerVo ticketTimeItem : ticketTimesPartnerVos) {
                //创建场次
                KylinTicketTimes ticketTimes = new KylinTicketTimes();
                BeanUtils.copyProperties(ticketTimeItem, ticketTimes);
                KylinTicketTimeRelation ticketTimeRelation = new KylinTicketTimeRelation();
                BeanUtils.copyProperties(ticketTimeItem, ticketTimeRelation);

                ticketTimes.setUseStart(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketTimeItem.getUseStart())));
                ticketTimes.setUseEnd(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketTimeItem.getUseEnd())));
                ticketTimes.setCreatedAt(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketTimeItem.getCreatedAt())));
                ticketTimes.setUpdatedAt(updatedAt);

                ticketTimeRelation.setPerformanceId(performancesId);
                ticketTimeRelation.setTicketTimeRelationId(IDGenerator.nextSnowId().toString());
                ticketTimeRelation.setTimesId(ticketTimes.getTicketTimesId());
                ticketTimeRelation.setCreatedAt(ticketTimes.getCreatedAt());
                ticketTimeRelation.setUpdatedAt(updatedAt);

                ticketTimesMapper.insert(ticketTimes);
                ticketTimeRelationMapper.insert(ticketTimeRelation);

                //修改票
                for (TicketPartnerVo ticketItem : ticketsPartnerService.getTicketMongoList(ticketTimeItem.getTicketTimesId())) {
                    BasicDBObject objectTicketVo = new BasicDBObject("$set", mongoConverter.convertToMongoType(map));
                    Document docTicket = mongoTemplate.getCollection(TicketPartnerVo.class.getSimpleName()).findOneAndUpdate(
                            Query.query(Criteria.where("ticketsId").is(ticketItem.getTicketsId())).getQueryObject(),
                            objectTicketVo,
                            new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER)
                    );
                    TicketPartnerVo ticketPartnerVo = JsonUtils.fromJson(docTicket.toJson(), TicketPartnerVo.class);

                    //创建演出
                    KylinTickets tickets = new KylinTickets();
                    BeanUtils.copyProperties(ticketPartnerVo, tickets);
                    KylinTicketStatus ticketStatus = new KylinTicketStatus();
                    BeanUtils.copyProperties(ticketPartnerVo, ticketStatus);
                    KylinTicketRelations ticketRelations = new KylinTicketRelations();
                    BeanUtils.copyProperties(ticketPartnerVo, ticketRelations);

                    tickets.setPriceExpress(new BigDecimal("0.00"));
                    tickets.setPriceDiscountMember(new BigDecimal("0.00"));
                    tickets.setPriceDiscount(new BigDecimal("0.00"));
                    tickets.setTimeStart(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketItem.getTimeStart())));
                    tickets.setTimeEnd(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketItem.getTimeEnd())));
                    if (ticketItem.getIsExpress() == 1) {
                        tickets.setTimeEndExpress(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketItem.getTimeEndExpress())));
                    }
                    tickets.setUseStart(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketTimeItem.getUseStart())));
                    tickets.setUseEnd(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketTimeItem.getUseEnd())));
                    tickets.setSaleRemindMinute(60);
                    tickets.setCreatedAt(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketItem.getCreatedAt())));
                    tickets.setUpdatedAt(updatedAt);

                    ticketStatus.setTicketStatusId(IDGenerator.nextSnowId().toString());
                    ticketStatus.setTicketId(tickets.getTicketsId());
                    ticketStatus.setCounts(1);
                    ticketStatus.setIsMember(1);
                    ticketStatus.setIsExclusive(0);
                    ticketStatus.setIsTrueName(performanceStatus.getIsTrueName());
                    ticketStatus.setMemberLimitCount(1);
                    ticketStatus.setStatusExchange(7);
                    if (ticketItem.getIsShowCode() == 1) {
                        ticketStatus.setQrCodeShowTime(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketItem.getQrCodeShowTime())));
                    }

                    ticketRelations.setCreatedAt(tickets.getCreatedAt());
                    ticketRelations.setUpdatedAt(updatedAt);

                    ticketRelations.setTicketRelationsId(IDGenerator.nextSnowId().toString());
                    ticketRelations.setTicketId(tickets.getTicketsId());
                    ticketRelations.setCreatedAt(tickets.getCreatedAt());
                    ticketRelations.setUpdatedAt(updatedAt);

                    ticketsMapper.insert(tickets);
                    ticketStatusMapper.insert(ticketStatus);
                    ticketRelationsMapper.insert(ticketRelations);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 修改数据库
     *
     * @param performancesId
     * @param map
     * @param performanceUpdateMisVo
     * @param updatedAt
     */
    public void updatePerformanceMySql(String performancesId, HashMap<String, Object> map, PerformanceMisVo performanceUpdateMisVo, LocalDateTime updatedAt) {
        try {
            //创建演出
            KylinPerformances performances = new KylinPerformances();
            BeanUtils.copyProperties(performanceUpdateMisVo, performances);
            KylinPerformanceStatus performanceStatus = new KylinPerformanceStatus();
            BeanUtils.copyProperties(performanceUpdateMisVo, performanceStatus);
            KylinPerformanceRelations performanceRelations = new KylinPerformanceRelations();
            BeanUtils.copyProperties(performanceUpdateMisVo, performanceRelations);

            performances.setCreatedAt(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(performanceUpdateMisVo.getCreatedAt())));
            performances.setTimeStart(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(performanceUpdateMisVo.getTimeStart())));
            performances.setTimeEnd(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(performanceUpdateMisVo.getTimeEnd())));
            performances.setUpdatedAt(updatedAt);

            performanceStatus.setPerformanceId(performances.getPerformancesId());
            performanceStatus.setPerformanceStatusId(IDGenerator.nextSnowId().toString());
            performanceStatus.setCreatedAt(null);
            performanceStatus.setAuditStatus(0);
            performanceStatus.setUpdatedAt(updatedAt);

            performanceRelations.setPerformanceId(performances.getPerformancesId());
            performanceRelations.setPerformanceRelationsId(IDGenerator.nextSnowId().toString());
            performanceRelations.setCreatedAt(null);
            performanceRelations.setUpdatedAt(updatedAt);

            performancesMapper.update(performances, new UpdateWrapper<KylinPerformances>().eq("performances_id", performances.getPerformancesId()));
            performanceStatusMapper.update(performanceStatus, new UpdateWrapper<KylinPerformanceStatus>().eq("performance_id", performances.getPerformancesId()));
            performanceRelationsMapper.update(performanceRelations, new UpdateWrapper<KylinPerformanceRelations>().eq("performance_id", performances.getPerformancesId()));


            //场次数据
            List<TicketTimesPartnerVo> ticketTimesPartnerVos = ticketTimesPartnerService.getTimesMongoList(performancesId);
            for (TicketTimesPartnerVo ticketTimeItem : ticketTimesPartnerVos) {
                //创建场次
                KylinTicketTimes ticketTimes = new KylinTicketTimes();
                BeanUtils.copyProperties(ticketTimeItem, ticketTimes);
                KylinTicketTimeRelation ticketTimeRelation = new KylinTicketTimeRelation();
                BeanUtils.copyProperties(ticketTimeItem, ticketTimeRelation);

                ticketTimes.setUseStart(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketTimeItem.getUseStart())));
                ticketTimes.setUseEnd(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketTimeItem.getUseEnd())));
                ticketTimes.setCreatedAt(null);
                ticketTimes.setUpdatedAt(updatedAt);

                ticketTimeRelation.setPerformanceId(performancesId);
                ticketTimeRelation.setTicketTimeRelationId(IDGenerator.nextSnowId().toString());
                ticketTimeRelation.setTimesId(ticketTimes.getTicketTimesId());
                ticketTimeRelation.setCreatedAt(null);
                ticketTimeRelation.setUpdatedAt(updatedAt);

                ticketTimesMapper.update(ticketTimes, new UpdateWrapper<KylinTicketTimes>().eq("ticket_times_id", ticketTimes.getTicketTimesId()));
                ticketTimeRelationMapper.update(ticketTimeRelation, new UpdateWrapper<KylinTicketTimeRelation>().eq("ticket_time_id", ticketTimes.getTicketTimesId()));

                //修改票
                for (TicketPartnerVo ticketItem : ticketsPartnerService.getTicketMongoList(ticketTimeItem.getTicketTimesId())) {
                    TicketPartnerVo ticketPartnerVo;
                    if (ticketItem.getStatus() != 7) {
                        BasicDBObject objectTicketVo = new BasicDBObject("$set", mongoConverter.convertToMongoType(map));
                        Document docTicket = mongoTemplate.getCollection(TicketPartnerVo.class.getSimpleName()).findOneAndUpdate(
                                Query.query(Criteria.where("ticketsId").is(ticketItem.getTicketsId())).getQueryObject(),
                                objectTicketVo,
                                new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER)
                        );
                        ticketPartnerVo = JsonUtils.fromJson(docTicket.toJson(), TicketPartnerVo.class);
                    } else {
                        ticketPartnerVo = mongoTemplate.findOne(
                                Query.query(Criteria.where("ticketsId").is(ticketItem.getTicketsId())),
                                TicketPartnerVo.class,
                                TicketPartnerVo.class.getSimpleName()
                        );
                    }

                    //创建演出
                    KylinTickets tickets = new KylinTickets();
                    BeanUtils.copyProperties(ticketPartnerVo, tickets);
                    KylinTicketStatus ticketStatus = new KylinTicketStatus();
                    BeanUtils.copyProperties(ticketPartnerVo, ticketStatus);
                    KylinTicketRelations ticketRelations = new KylinTicketRelations();
                    BeanUtils.copyProperties(ticketPartnerVo, ticketRelations);

                    tickets.setPriceExpress(new BigDecimal("0.00"));
                    tickets.setPriceDiscountMember(new BigDecimal("0.00"));
                    tickets.setPriceDiscount(new BigDecimal("0.00"));
                    tickets.setTimeStart(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketItem.getTimeStart())));
                    tickets.setTimeEnd(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketItem.getTimeEnd())));
                    tickets.setTimeEndExpress(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketItem.getTimeEndExpress())));
                    tickets.setUseStart(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketTimeItem.getUseStart())));
                    tickets.setUseEnd(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketTimeItem.getUseEnd())));
                    tickets.setSaleRemindMinute(60);
                    tickets.setCreatedAt(null);
                    tickets.setUpdatedAt(updatedAt);

                    ticketStatus.setTicketStatusId(IDGenerator.nextSnowId().toString());
                    ticketStatus.setTicketId(tickets.getTicketsId());
                    ticketStatus.setCounts(1);
                    ticketStatus.setIsMember(null);
                    ticketStatus.setStatusExchange(7);
                    ticketStatus.setQrCodeShowTime(DateUtil.asLocalDateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ticketItem.getQrCodeShowTime())));
                    //不改动数据 价格 限购 购票时间
                    ticketStatus.setLimitCount(null);
                    ticketStatus.setTotalGeneral(null);
                    ticketStatus.setTotalExchange(null);
                    tickets.setTimeStart(null);
                    tickets.setTimeEnd(null);

                    ticketRelations.setCreatedAt(null);
                    ticketRelations.setUpdatedAt(updatedAt);

                    ticketRelations.setTicketRelationsId(IDGenerator.nextSnowId().toString());
                    ticketRelations.setTicketId(tickets.getTicketsId());
                    ticketRelations.setCreatedAt(null);
                    ticketRelations.setUpdatedAt(updatedAt);

                    ticketsMapper.update(tickets, new UpdateWrapper<KylinTickets>().eq("tickets_id", tickets.getTicketsId()));
                    ticketStatusMapper.update(ticketStatus, new UpdateWrapper<KylinTicketStatus>().eq("tickets_id", tickets.getTicketsId()));
                    ticketRelationsMapper.update(ticketRelations, new UpdateWrapper<KylinTicketRelations>().eq("tickets_id", tickets.getTicketsId()));
                }
            }
        } catch (Exception e) {

        }
    }

}
