package com.liquidnet.client.admin.zhengzai.kylin.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.kylin.dao.RoadShowAdminListDao;
import com.liquidnet.service.kylin.dto.param.CreateRoadShowParam;
import com.liquidnet.service.kylin.dto.vo.KylinRoadShowVo;
import com.liquidnet.service.kylin.dto.vo.admin.KylinRoadShowAdminVo;
import com.liquidnet.service.kylin.entity.KylinRoadShows;
import com.liquidnet.service.kylin.mapper.KylinRoadShowsMapper;
import com.liquidnet.service.kylin.service.admin.IKylinRoadShowsAdminService;
import com.mongodb.BasicDBObject;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;

/**
 * <p>
 * 巡演 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-11
 */
@Service
public class KylinRoadShowsAdminServiceImpl extends ServiceImpl<KylinRoadShowsMapper, KylinRoadShows> implements IKylinRoadShowsAdminService {

    @Autowired
    private MongoTemplate mongoTemplate;

    @Autowired
    private MongoConverter mongoConverter;

    @Autowired
    private KylinRoadShowsMapper kylinRoadShowsMapper;

    @Override
    public String createRoadShow(CreateRoadShowParam createRoadShowParam) {
        try {
            String roadShowId = IDGenerator.nextSnowId().toString();
            createRoadShowParam.setStatus(1);
            createRoadShowParam.setRoadShowsId(roadShowId);
            createRoadShowParam.setCreatedAt(LocalDateTime.now());
            KylinRoadShows roadShows = new KylinRoadShows();
            BeanUtils.copyProperties(createRoadShowParam, roadShows);
            kylinRoadShowsMapper.insert(roadShows);
            KylinRoadShowVo kylinRoadShowVo = new KylinRoadShowVo();
            BeanUtils.copyProperties(createRoadShowParam, kylinRoadShowVo);
            mongoTemplate.insert(roadShows, KylinRoadShowVo.class.getSimpleName());
            return roadShowId;
        } catch (Exception e) {
            return "";
        }
    }

    @Override
    public boolean updateRoadShow(CreateRoadShowParam createRoadShowParam) {
        try {
            KylinRoadShows roadShows = new KylinRoadShows();
            createRoadShowParam.setUpdatedAt(LocalDateTime.now());
            createRoadShowParam.setStatus(null);
            BeanUtils.copyProperties(createRoadShowParam, roadShows);
            kylinRoadShowsMapper.update(roadShows, new UpdateWrapper<KylinRoadShows>().eq("road_shows_id", createRoadShowParam.getRoadShowsId()));
            KylinRoadShowVo kylinRoadShowVo = new KylinRoadShowVo();
            BeanUtils.copyProperties(createRoadShowParam, kylinRoadShowVo);

            BasicDBObject objectRoadShowVo = new BasicDBObject("$set", mongoConverter.convertToMongoType(roadShows));
            mongoTemplate.getCollection(KylinRoadShows.class.getSimpleName()).updateOne(
                    Query.query(Criteria.where("roadShowsId").is(createRoadShowParam.getRoadShowsId())).getQueryObject(),
                    objectRoadShowVo);
            return true;
        } catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean deleteRoadShow(String roadShowId, int status) {

        KylinRoadShows roadShows = new KylinRoadShows();
        roadShows.setStatus(status);
        roadShows.setUpdatedAt(LocalDateTime.now());
        kylinRoadShowsMapper.update(roadShows, new UpdateWrapper<KylinRoadShows>().eq("road_shows_id", roadShowId));

        BasicDBObject objectRoadShowVo = new BasicDBObject("$set", mongoConverter.convertToMongoType(roadShows));
        mongoTemplate.getCollection(KylinRoadShows.class.getSimpleName()).updateOne(
                Query.query(Criteria.where("roadShowsId").is(roadShowId)).getQueryObject(),
                objectRoadShowVo);

        return false;
    }

    @Override
    public KylinRoadShowAdminVo detailsRoadShow(String roadShowId) {
        KylinRoadShows data = kylinRoadShowsMapper.selectOne(new UpdateWrapper<KylinRoadShows>().eq("road_shows_id", roadShowId));
        KylinRoadShowAdminVo vo = new KylinRoadShowAdminVo();
        vo.setTitle(data.getTitle());
        vo.setRoadShowId(data.getRoadShowsId());
        vo.setStatus(data.getStatus());
        return vo;
    }

    @Override
    public PageInfo<RoadShowAdminListDao> listRoadShow(String title, int page, int size) {
        PageInfo<RoadShowAdminListDao> pageInfoTmp = null;
        try {
            HashMap<String, Object> map = new HashMap<>();
            map.put("title", title);
            PageHelper.startPage(page, size);
            List<RoadShowAdminListDao> voList = kylinRoadShowsMapper.misRoadShowList(map);
            pageInfoTmp = new PageInfo(voList);
        } catch (Exception e) {
            return null;
        }
        return pageInfoTmp;
    }
}
