package com.liquidnet.service.kylin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 巡演
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-11
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class KylinRoadShows implements Serializable ,Cloneable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Integer mid;

    /**
     * road_shows_id
     */
    private String roadShowsId;

    /**
     * 巡演封面图
     */
    private String title;

    /**
     * 巡演封面图
     */
    private String imgPoster;

    /**
     * 状态 0停用 1启用
     */
    private Integer status;

    /**
     * comment
     */
    private String comment;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 修改时间
     */
    private LocalDateTime updatedAt;

    private static final KylinRoadShows obj = new KylinRoadShows();
    public static KylinRoadShows getNew() {
        try {
            return (KylinRoadShows) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new KylinRoadShows();
        }
    }
}
