package com.liquidnet.service.goblin.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <p>
 * 
 * </p>
 *
 * @author jobob
 * @since 2022-03-11
 */
@ApiModel(value = "smileUser", description = "smile的user")
@Data
public class SmileUserVO implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;
    @ApiModelProperty(value = "用户id")
    private String uid;

    /**
     * 照片
     */
    @ApiModelProperty(value = "照片")
    private String img;

    /**
     * 真实姓名
     */
    @ApiModelProperty(value = "真实姓名")
    private String name;

    /**
     * 生日YYYY-MM-DD
     */
    @ApiModelProperty(value = "生日")
    private LocalDate birthday;

    /**
     * 性别(1：男（默认），2：女)
     */
    @ApiModelProperty(value = "性别(1：男（默认），2：女)")
    private Integer sex;

    /**
     * 手机号
     */
    @ApiModelProperty(value = "手机号")
    private String phone;

    /**
     * 省key
     */
    @ApiModelProperty(value = "省key")
    private Integer provinceKey;

    /**
     * 省
     */
    @ApiModelProperty(value = "省")
    private String province;

    /**
     * 市key
     */
    @ApiModelProperty(value = "市key")
    private Integer cityKey;

    /**
     * 市
     */
    @ApiModelProperty(value = "市")
    private String city;

    /**
     * 区key
     */
    @ApiModelProperty(value = "区key")
    private Integer areaKey;

    /**
     * 区
     */
    @ApiModelProperty(value = "区")
    private String area;

    /**
     * 详细地址
     */
    @ApiModelProperty(value = "详细地址")
    private String address;

    /**
     * 微信号
     */
    @ApiModelProperty(value = "微信号")
    private String wechat;

    /**
     * 代理类型（1：总代，2：普代）
     */
    @ApiModelProperty(value = "代理类型（1：总代，2：普代）")
    private Integer type;

    /**
     * 组织关联
     */
    @ApiModelProperty(value = "组织关联")
    private Long orgId;

    /**
     * 身份证号
     */
    @ApiModelProperty(value = "身份证号")
    private Long idCard;

    /**
     * 学校名称
     */
    @ApiModelProperty(value = "学校名称")
    private String schoolName;

    /**
     * 专业
     */
    @ApiModelProperty(value = "专业")
    private String schoolMajor;

    /**
     * 身份（1:在校学生（默认），2已毕业）
     */
    @ApiModelProperty(value = "身份（1:在校学生（默认），2已毕业）")
    private Integer identity;

    /**
     * 标识步骤
     */
    @ApiModelProperty(value = "标识步骤")
    private String tag;

    /**
     * 1：代理开启，2：代理关闭
     */
    @ApiModelProperty(value = "1：代理开启，2：代理关闭")
    private Integer agent;

    /**
     * 自我介绍
     */
    @ApiModelProperty(value = "自我介绍")
    private String introduce;

    /**
     * 擅长1
     */
    @ApiModelProperty(value = "擅长1")
    private String specialty1;

    /**
     * 擅长2
     */
    @ApiModelProperty(value = "擅长2")
    private String specialty2;

    /**
     * 擅长3
     */
    @ApiModelProperty(value = "擅长3")
    private String specialty3;

    /**
     * 正常/黑名单
     */
    @ApiModelProperty(value = "正常/黑名单")
    private Integer state;

    /**
     * 0：删除，1正常
     */
    @ApiModelProperty(value = "0：删除，1正常")
    private Integer delTag;
    /**
     * 认证标识
     */
    @ApiModelProperty(value = "（0:未审核，1：通过，2：未通过）")
    private Integer authTag;

    /**
     * 认证失败原因
     */
    @ApiModelProperty(value = "认证失败原因")
    private String errorReason;

    private LocalDateTime createdDate;

    private LocalDateTime updatedDate;


}
