package com.liquidnet.service.bank.currencycloud.service.impl;

import com.currencycloud.client.CurrencyCloudClient;
import com.currencycloud.client.model.ConversionDates;
import com.currencycloud.client.model.DetailedRate;
import com.currencycloud.client.model.Rates;
import com.liquidnet.commons.lang.util.DateUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

/**
 * @author Li Chen
 * @date 2020-10-12 14:55
 */
@SpringBootTest
@RunWith(SpringRunner.class)
public class BankCcRateServiceImplTest {

    @Autowired
    CurrencyCloudClient currencyCloudClient;


    @Test
    public void getRate() {

        // 必填参数
        String currencyPair = "GBPUSD";

        // 选填参数
        String on_behalf_of = "11";
        boolean ignore_invalid_pairs = false;
        String[] currencyPairArray = {"USDGBP","USDEUR","USDCNY","GBPUSD","EURUSD","CNYUSD","GBPCNY","CNYGBP"};
        List<String> currencyPairList = Arrays.asList(currencyPairArray);

        // 创建cc sdk请求对象Account
//        Collection<String> currencyPair, @Nullable Boolean ignoreInvalidPairs
        Rates rates = currencyCloudClient.findRates(currencyPairList,Boolean.TRUE);
        System.out.println("rates=== "+rates.toString());
        //{"unavailable":[],"rates":{"USDGBP":[0.710076,0.710379],"USDEUR":[0.843099,0.843597],"USDCNY":[7.122750,7.124780],
        // "GBPUSD":[1.407700,1.408300],"EURUSD":[1.185400,1.186100],"CNYUSD":[0.140355,0.140395]}}
//        rates=== {"unavailable":[],"rates":{"USDGBP":[0.710076,0.710379],"USDEUR":[0.843099,0.843597],"USDCNY":[7.122750,7.124780],
//        "GBPUSD":[1.407700,1.408300],"EURUSD":[1.185400,1.186100],"CNYUSD":[0.140355,0.140395],
//        "GBPCNY":[8.863500,8.867460],"CNYGBP":[0.112772,0.112822]}}
    }

    @Test
    public void detailedRates() {//USDGBP

        // 必填参数
        String buyCurrency = "GBP";
        String sellCurrency = "USD";
        String fixedSide = "buy";
        BigDecimal amount = BigDecimal.valueOf(100);
        // 选填参数
         Date conversionDate = null;
        String conversionDatePreference = null;
        try {
             conversionDate = DateUtil.parse("2020-10-29", DateUtil.Formatter.yyyy_MM_dd.toString());
        } catch (ParseException e) {
            e.printStackTrace();
        }
        DetailedRate detailedRate = currencyCloudClient.detailedRates(buyCurrency,sellCurrency,fixedSide,amount,conversionDate,conversionDatePreference);
        System.out.println("USDGBP buy detailedRate=== "+detailedRate.toString());
//        USDGBP buy detailedRate=== {"depositAmount":0.0,"midMarketRate":1.4100,"currencyPair":["GBPUSD"],"depositRequired":false,"clientBuyCurrency":"GBP","fixedSide":"buy","clientSellAmount":141.01,"settlementCutOffTime":"2020-11-02T23:00:00+08","clientSellCurrency":"USD","clientBuyAmount":100.00,"coreRate":1.4101,"depositCurrency":"USD","partnerRate":null,"clientRate":1.4101}


        // 必填参数
         buyCurrency = "GBP";
         sellCurrency = "USD";
         fixedSide = "sell";
         amount = BigDecimal.valueOf(100);
        // 选填参数
         conversionDate = null;
         conversionDatePreference = null;
        try {
            conversionDate = DateUtil.parse("2020-10-29", DateUtil.Formatter.yyyy_MM_dd.toString());
        } catch (ParseException e) {
            e.printStackTrace();
        }

         detailedRate = currencyCloudClient.detailedRates(buyCurrency,sellCurrency,fixedSide,amount,conversionDate,conversionDatePreference);
        System.out.println("USDGBP sell detailedRate=== "+detailedRate.toString());
//        USDGBP sell detailedRate=== {"depositAmount":0.0,"midMarketRate":1.4100,"currencyPair":["GBPUSD"],"depositRequired":false,"clientBuyCurrency":"GBP","fixedSide":"sell","clientSellAmount":100.00,"settlementCutOffTime":"2020-11-02T23:00:00+08","clientSellCurrency":"USD","clientBuyAmount":70.92,"coreRate":1.4101,"depositCurrency":"USD","partnerRate":null,"clientRate":1.4101}

    }

    @Test
    public void detailedRates2() {//GBPUSD

        // 必填参数
        String buyCurrency = "USD";
        String sellCurrency = "GBP";
        String fixedSide = "buy";
        BigDecimal amount = BigDecimal.valueOf(100);
        // 选填参数
        Date conversionDate = null;
        String conversionDatePreference = null;
        try {
            conversionDate = DateUtil.parse("2020-10-29", DateUtil.Formatter.yyyy_MM_dd.toString());
        } catch (ParseException e) {
            e.printStackTrace();
        }
        DetailedRate detailedRate = currencyCloudClient.detailedRates(buyCurrency,sellCurrency,fixedSide,amount,conversionDate,conversionDatePreference);
        System.out.println("GBPUSD buy detailedRates2=== "+detailedRate.toString());
//       GBPUSD buy detailedRates2=== {"depositAmount":0.0,"midMarketRate":1.4100,"currencyPair":["GBPUSD"],"depositRequired":false,"clientBuyCurrency":"USD","fixedSide":"buy","clientSellAmount":70.93,"settlementCutOffTime":"2020-11-03T00:30:00+08","clientSellCurrency":"GBP","clientBuyAmount":100.00,"coreRate":1.4099,"depositCurrency":"GBP","partnerRate":null,"clientRate":1.4099}


        // 必填参数
        buyCurrency = "USD";
        sellCurrency = "GBP";
        fixedSide = "sell";
        amount = BigDecimal.valueOf(100);
        // 选填参数
        conversionDate = null;
        conversionDatePreference = null;
        try {
            conversionDate = DateUtil.parse("2020-10-29", DateUtil.Formatter.yyyy_MM_dd.toString());
        } catch (ParseException e) {
            e.printStackTrace();
        }

        detailedRate = currencyCloudClient.detailedRates(buyCurrency,sellCurrency,fixedSide,amount,conversionDate,conversionDatePreference);
        System.out.println("GBPUSD sell detailedRates2=== "+detailedRate.toString());
//        GBPUSD sell detailedRates2=== {"depositAmount":0.0,"midMarketRate":1.4100,"currencyPair":["GBPUSD"],"depositRequired":false,"clientBuyCurrency":"USD","fixedSide":"sell","clientSellAmount":100.00,"settlementCutOffTime":"2020-11-03T00:30:00+08","clientSellCurrency":"GBP","clientBuyAmount":140.99,"coreRate":1.4099,"depositCurrency":"GBP","partnerRate":null,"clientRate":1.4099}

    }
    @Test
    public void detailedRates3() {//GBPCNY

        // 必填参数
        String buyCurrency = "CNY";
        String sellCurrency = "GBP";
        String fixedSide = "buy";
        BigDecimal amount = BigDecimal.valueOf(100);
        // 选填参数
        Date conversionDate = null;
        String conversionDatePreference = null;
        try {
            conversionDate = DateUtil.parse("2020-10-29", DateUtil.Formatter.yyyy_MM_dd.toString());
        } catch (ParseException e) {
            e.printStackTrace();
        }
        DetailedRate detailedRate = currencyCloudClient.detailedRates(buyCurrency,sellCurrency,fixedSide,amount,conversionDate,conversionDatePreference);
        System.out.println("GBPCNY buy detailedRates3=== "+detailedRate.toString());
//      GBPCNY buy detailedRates3=== {"depositAmount":0.0,"midMarketRate":8.8675,"currencyPair":["GBPCNY"],"depositRequired":false,"clientBuyCurrency":"CNY","fixedSide":"buy","clientSellAmount":11.28,"settlementCutOffTime":"2020-11-03T17:00:00+08","clientSellCurrency":"GBP","clientBuyAmount":100.00,"coreRate":8.8665,"depositCurrency":"GBP","partnerRate":null,"clientRate":8.8665}


        // 必填参数
        buyCurrency = "CNY";
        sellCurrency = "GBP";
        fixedSide = "sell";
        amount = BigDecimal.valueOf(100);
        // 选填参数
        conversionDate = null;
        conversionDatePreference = null;
        try {
            conversionDate = DateUtil.parse("2020-10-29", DateUtil.Formatter.yyyy_MM_dd.toString());
        } catch (ParseException e) {
            e.printStackTrace();
        }

        detailedRate = currencyCloudClient.detailedRates(buyCurrency,sellCurrency,fixedSide,amount,conversionDate,conversionDatePreference);
        System.out.println("GBPCNY sell detailedRates3=== "+detailedRate.toString());
//       GBPCNY sell detailedRates3=== {"depositAmount":0.0,"midMarketRate":8.8675,"currencyPair":["GBPCNY"],"depositRequired":false,"clientBuyCurrency":"CNY","fixedSide":"sell","clientSellAmount":100.00,"settlementCutOffTime":"2020-11-03T17:00:00+08","clientSellCurrency":"GBP","clientBuyAmount":886.65,"coreRate":8.8665,"depositCurrency":"GBP","partnerRate":null,"clientRate":8.8665}

    }

    @Test
    public void detailedRates4() {//CNYGBP

        // 必填参数
        String buyCurrency = "GBP";
        String sellCurrency = "CNY";
        String fixedSide = "buy";
        BigDecimal amount = BigDecimal.valueOf(100);
        // 选填参数
        Date conversionDate = null;
        String conversionDatePreference = "earliest";
        try {
            conversionDate = DateUtil.parse("2020-11-09", DateUtil.Formatter.yyyy_MM_dd.toString());
        } catch (ParseException e) {
            e.printStackTrace();
        }
        DetailedRate detailedRate = currencyCloudClient.detailedRates(buyCurrency,sellCurrency,fixedSide,amount,conversionDate,conversionDatePreference);
        System.out.println("CNYGBP buy detailedRates4=== "+detailedRate.toString());
//      CNYGBP buy detailedRates4=== {"depositAmount":0.0,"midMarketRate":8.8675,"currencyPair":["GBPCNY"],"depositRequired":false,"clientBuyCurrency":"GBP","fixedSide":"buy","clientSellAmount":886.85,"settlementCutOffTime":"2020-11-03T17:00:00+08","clientSellCurrency":"CNY","clientBuyAmount":100.00,"coreRate":8.8685,"depositCurrency":"CNY","partnerRate":null,"clientRate":8.8685}


        // 必填参数
        buyCurrency = "GBP";
        sellCurrency = "CNY";
        fixedSide = "sell";
        amount = BigDecimal.valueOf(100);
        // 选填参数
        conversionDate = null;
        conversionDatePreference = null;
        try {
            conversionDate = DateUtil.parse("2020-10-29", DateUtil.Formatter.yyyy_MM_dd.toString());
        } catch (ParseException e) {
            e.printStackTrace();
        }

        detailedRate = currencyCloudClient.detailedRates(buyCurrency,sellCurrency,fixedSide,amount,conversionDate,conversionDatePreference);
        System.out.println("CNYGBP sell detailedRates4=== "+detailedRate.toString());
//     CNYGBP sell detailedRates4=== {"depositAmount":0.0,"midMarketRate":8.8675,"currencyPair":["GBPCNY"],"depositRequired":false,"clientBuyCurrency":"GBP","fixedSide":"sell","clientSellAmount":100.00,"settlementCutOffTime":"2020-11-03T17:00:00+08","clientSellCurrency":"CNY","clientBuyAmount":11.28,"coreRate":8.8685,"depositCurrency":"CNY","partnerRate":null,"clientRate":8.8685}

    }



    @Test
    public void detailedRates5() {//USDJPY

        // 必填参数
        String buyCurrency = "JPY";
        String sellCurrency = "USD";
        String fixedSide = "buy";
        BigDecimal amount = BigDecimal.valueOf(100);
        // 选填参数
        Date conversionDate = null;
        String conversionDatePreference = null;
        try {
            conversionDate = DateUtil.parse("2020-10-29", DateUtil.Formatter.yyyy_MM_dd.toString());
        } catch (ParseException e) {
            e.printStackTrace();
        }
        DetailedRate detailedRate = currencyCloudClient.detailedRates(buyCurrency,sellCurrency,fixedSide,amount,conversionDate,conversionDatePreference);
        System.out.println("USDJPY buy detailedRates3=== "+detailedRate.toString());
//      USDJPY buy detailedRates3=== {"depositAmount":0.0,"midMarketRate":113.2479,"currencyPair":["USDJPY"],"depositRequired":false,"clientBuyCurrency":"JPY","fixedSide":"buy","clientSellAmount":0.88,"settlementCutOffTime":"2020-11-12T22:00:00+08","clientSellCurrency":"USD","clientBuyAmount":100,"coreRate":113.2233,"depositCurrency":"USD","partnerRate":null,"clientRate":113.2233}


        // 必填参数
        buyCurrency = "JPY";
        sellCurrency = "USD";
        fixedSide = "sell";
        amount = BigDecimal.valueOf(100);
        // 选填参数
        conversionDate = null;
        conversionDatePreference = null;
        try {
            conversionDate = DateUtil.parse("2020-10-29", DateUtil.Formatter.yyyy_MM_dd.toString());
        } catch (ParseException e) {
            e.printStackTrace();
        }

        detailedRate = currencyCloudClient.detailedRates(buyCurrency,sellCurrency,fixedSide,amount,conversionDate,conversionDatePreference);
        System.out.println("USDJPY sell detailedRates3=== "+detailedRate.toString());
//       USDJPY sell detailedRates3=== {"depositAmount":0.0,"midMarketRate":113.2479,"currencyPair":["USDJPY"],"depositRequired":false,"clientBuyCurrency":"JPY","fixedSide":"sell","clientSellAmount":100.00,"settlementCutOffTime":"2020-11-12T22:00:00+08","clientSellCurrency":"USD","clientBuyAmount":11322,"coreRate":113.2233,"depositCurrency":"USD","partnerRate":null,"clientRate":113.2233}

    }

    @Test
    public void detailedRates6() {//USDJPY

        // 必填参数
        String buyCurrency = "JPY";
        String sellCurrency = "USD";
        String fixedSide = "buy";
        BigDecimal amount = BigDecimal.valueOf(100);
        // 选填参数
        Date conversionDate = null;
        String conversionDatePreference = "earliest";
        try {
            conversionDate = DateUtil.parse("2020-11-09", DateUtil.Formatter.yyyy_MM_dd.toString());
        } catch (ParseException e) {
            e.printStackTrace();
        }
        DetailedRate detailedRate = currencyCloudClient.detailedRates(buyCurrency,sellCurrency,fixedSide,amount,conversionDate,conversionDatePreference);
        System.out.println("USDJPY buy detailedRates4=== "+detailedRate.toString());
//      CNYGBP buy detailedRates4=== {"depositAmount":0.0,"midMarketRate":8.8675,"currencyPair":["GBPCNY"],"depositRequired":false,"clientBuyCurrency":"GBP","fixedSide":"buy","clientSellAmount":886.85,"settlementCutOffTime":"2020-11-03T17:00:00+08","clientSellCurrency":"CNY","clientBuyAmount":100.00,"coreRate":8.8685,"depositCurrency":"CNY","partnerRate":null,"clientRate":8.8685}


        // 必填参数
        buyCurrency = "JPY";
        sellCurrency = "USD";
        fixedSide = "sell";
        amount = BigDecimal.valueOf(100);
        // 选填参数
        conversionDate = null;
        conversionDatePreference = null;
        try {
            conversionDate = DateUtil.parse("2020-10-29", DateUtil.Formatter.yyyy_MM_dd.toString());
        } catch (ParseException e) {
            e.printStackTrace();
        }

        detailedRate = currencyCloudClient.detailedRates(buyCurrency,sellCurrency,fixedSide,amount,conversionDate,conversionDatePreference);
        System.out.println("USDJPY sell detailedRates4=== "+detailedRate.toString());
//     CNYGBP sell detailedRates4=== {"depositAmount":0.0,"midMarketRate":8.8675,"currencyPair":["GBPCNY"],"depositRequired":false,"clientBuyCurrency":"GBP","fixedSide":"sell","clientSellAmount":100.00,"settlementCutOffTime":"2020-11-03T17:00:00+08","clientSellCurrency":"CNY","clientBuyAmount":11.28,"coreRate":8.8685,"depositCurrency":"CNY","partnerRate":null,"clientRate":8.8685}

    }

    //reference/conversion_dates
    //ConversionDates conversionDates(String conversionPair, @Nullable Date startDate
    @Test
    public void referenceConversionDates() {

        // 必填参数
        String conversionPair = "GBPCNY";
        Date startDate = null;
        try {
            startDate = DateUtil.parse("2020-11-01", DateUtil.Formatter.yyyy_MM_dd.toString());
        } catch (ParseException e) {
            e.printStackTrace();
        }

        ConversionDates conversionDates = currencyCloudClient.conversionDates(conversionPair,startDate);
        System.out.println("referenceConversionDates conversionDates=== "+conversionDates.toString());
//       referenceConversionDates conversionDates=== {"defaultConversionDate":"2020-11-03T08:00:00+08","firstConversionDate":"2020-10-30T08:00:00+08","invalidConversionDates":{"2020-10-31T08:00:00+08":"No trading on Saturday","2020-11-01T08:00:00+08":"No trading on Sunday","2020-11-07T08:00:00+08":"No trading on Saturday","2020-11-08T08:00:00+08":"No trading on Sunday","2020-11-11T08:00:00+08":"USD bank holiday (triangulation)","2020-11-14T08:00:00+08":"No trading on Saturday","2020-11-15T08:00:00+08":"No trading on Sunday","2020-11-21T08:00:00+08":"No trading on Saturday","2020-11-22T08:00:00+08":"No trading on Sunday","2020-11-26T08:00:00+08":"USD bank holiday (triangulation)","2020-11-28T08:00:00+08":"No trading on Saturday","2020-11-29T08:00:00+08":"No trading on Sunday","2020-12-05T08:00:00+08":"No trading on Saturday","2020-12-06T08:00:00+08":"No trading on Sunday","2020-12-12T08:00:00+08":"No trading on Saturday","2020-12-13T08:00:00+08":"No trading on Sunday","2020-12-19T08:00:00+08":"No trading on Saturday","2020-12-20T08:00:00+08":"No trading on Sunday","2020-12-25T08:00:00+08":"Christmas","2020-12-26T08:00:00+08":"No trading on Saturday","2020-12-27T08:00:00+08":"No trading on Sunday","2020-12-28T08:00:00+08":"Boxing Day OBS","2021-01-01T08:00:00+08":"New Year's Day","2021-01-02T08:00:00+08":"No trading on Saturday","2021-01-03T08:00:00+08":"No trading on Sunday","2021-01-09T08:00:00+08":"No trading on Saturday","2021-01-10T08:00:00+08":"No trading on Sunday","2021-01-16T08:00:00+08":"No trading on Saturday","2021-01-17T08:00:00+08":"No trading on Sunday","2021-01-18T08:00:00+08":"USD bank holiday (triangulation)","2021-01-23T08:00:00+08":"No trading on Saturday","2021-01-24T08:00:00+08":"No trading on Sunday","2021-01-30T08:00:00+08":"No trading on Saturday","2021-01-31T08:00:00+08":"No trading on Sunday","2021-02-06T08:00:00+08":"No trading on Saturday","2021-02-07T08:00:00+08":"No trading on Sunday","2021-02-11T08:00:00+08":"Lunar NY Eve 1","2021-02-12T08:00:00+08":"Lunar New Year 1","2021-02-13T08:00:00+08":"No trading on Saturday","2021-02-14T08:00:00+08":"No trading on Sunday","2021-02-15T08:00:00+08":"Lunar New Year 4","2021-02-16T08:00:00+08":"Lunar New Year 5","2021-02-17T08:00:00+08":"Lunar New Year 6","2021-02-20T08:00:00+08":"No trading on Saturday","2021-02-21T08:00:00+08":"No trading on Sunday","2021-02-27T08:00:00+08":"No trading on Saturday","2021-02-28T08:00:00+08":"No trading on Sunday","2021-03-06T08:00:00+08":"No trading on Saturday","2021-03-07T08:00:00+08":"No trading on Sunday","2021-03-13T08:00:00+08":"No trading on Saturday","2021-03-14T08:00:00+08":"No trading on Sunday","2021-03-20T08:00:00+08":"No trading on Saturday","2021-03-21T08:00:00+08":"No trading on Sunday","2021-03-27T08:00:00+08":"No trading on Saturday","2021-03-28T08:00:00+08":"No trading on Sunday","2021-04-02T08:00:00+08":"Good Friday","2021-04-03T08:00:00+08":"No trading on Saturday","2021-04-04T08:00:00+08":"No trading on Sunday","2021-04-05T08:00:00+08":"Easter Monday","2021-04-06T08:00:00+08":"HKD bank holiday (triangulation)","2021-04-10T08:00:00+08":"No trading on Saturday","2021-04-11T08:00:00+08":"No trading on Sunday","2021-04-17T08:00:00+08":"No trading on Saturday","2021-04-18T08:00:00+08":"No trading on Sunday","2021-04-24T08:00:00+08":"No trading on Saturday","2021-04-25T08:00:00+08":"No trading on Sunday","2021-05-01T08:00:00+08":"No trading on Saturday","2021-05-02T08:00:00+08":"No trading on Sunday","2021-05-03T08:00:00+08":"Early May Bank Holiday","2021-05-08T08:00:00+08":"No trading on Saturday","2021-05-09T08:00:00+08":"No trading on Sunday","2021-05-15T08:00:00+08":"No trading on Saturday","2021-05-16T08:00:00+08":"No trading on Sunday","2021-05-19T08:00:00+08":"HKD bank holiday (triangulation)","2021-05-22T08:00:00+08":"No trading on Saturday","2021-05-23T08:00:00+08":"No trading on Sunday","2021-05-29T08:00:00+08":"No trading on Saturday","2021-05-30T08:00:00+08":"No trading on Sunday","2021-05-31T08:00:00+08":"Late May Bank Holiday","2021-06-05T08:00:00+08":"No trading on Saturday","2021-06-06T08:00:00+08":"No trading on Sunday","2021-06-12T08:00:00+08":"No trading on Saturday","2021-06-13T08:00:00+08":"No trading on Sunday","2021-06-14T08:00:00+08":"Dragon Boat Festival (Tuen Ng Day)*","2021-06-19T08:00:00+08":"No trading on Saturday","2021-06-20T08:00:00+08":"No trading on Sunday","2021-06-26T08:00:00+08":"No trading on Saturday","2021-06-27T08:00:00+08":"No trading on Sunday","2021-07-01T08:00:00+08":"HKD bank holiday (triangulation)","2021-07-03T08:00:00+08":"No trading on Saturday","2021-07-04T08:00:00+08":"No trading on Sunday","2021-07-05T08:00:00+08":"USD bank holiday (triangulation)","2021-07-10T08:00:00+08":"No trading on Saturday","2021-07-11T08:00:00+08":"No trading on Sunday","2021-07-17T08:00:00+08":"No trading on Saturday","2021-07-18T08:00:00+08":"No trading on Sunday","2021-07-24T08:00:00+08":"No trading on Saturday","2021-07-25T08:00:00+08":"No trading on Sunday","2021-07-31T08:00:00+08":"No trading on Saturday","2021-08-01T08:00:00+08":"No trading on Sunday","2021-08-07T08:00:00+08":"No trading on Saturday","2021-08-08T08:00:00+08":"No trading on Sunday","2021-08-14T08:00:00+08":"No trading on Saturday","2021-08-15T08:00:00+08":"No trading on Sunday","2021-08-21T08:00:00+08":"No trading on Saturday","2021-08-22T08:00:00+08":"No trading on Sunday","2021-08-28T08:00:00+08":"No trading on Saturday","2021-08-29T08:00:00+08":"No trading on Sunday","2021-08-30T08:00:00+08":"Summer Bank Holiday","2021-09-04T08:00:00+08":"No trading on Saturday","2021-09-05T08:00:00+08":"No trading on Sunday","2021-09-06T08:00:00+08":"USD bank holiday (triangulation)","2021-09-11T08:00:00+08":"No trading on Saturday","2021-09-12T08:00:00+08":"No trading on Sunday","2021-09-18T08:00:00+08":"No trading on Saturday","2021-09-19T08:00:00+08":"No trading on Sunday","2021-09-20T08:00:00+08":"Mid-autumn Festival Holiday","2021-09-21T08:00:00+08":"Mid-autumn Festival*","2021-09-22T08:00:00+08":"HKD bank holiday (triangulation)","2021-09-25T08:00:00+08":"No trading on Saturday","2021-09-26T08:00:00+08":"No trading on Sunday","2021-10-01T08:00:00+08":"National Day 1","2021-10-02T08:00:00+08":"No trading on Saturday","2021-10-03T08:00:00+08":"No trading on Sunday","2021-10-04T08:00:00+08":"National Day 4","2021-10-05T08:00:00+08":"National Day 5","2021-10-06T08:00:00+08":"National Day 6","2021-10-07T08:00:00+08":"National Day 7","2021-10-09T08:00:00+08":"No trading on Saturday","2021-10-10T08:00:00+08":"No trading on Sunday","2021-10-11T08:00:00+08":"USD bank holiday (triangulation)","2021-10-14T08:00:00+08":"HKD bank holiday (triangulation)","2021-10-16T08:00:00+08":"No trading on Saturday","2021-10-17T08:00:00+08":"No trading on Sunday","2021-10-23T08:00:00+08":"No trading on Saturday","2021-10-24T08:00:00+08":"No trading on Sunday","2021-10-30T08:00:00+08":"No trading on Saturday","2021-10-31T08:00:00+08":"No trading on Sunday","2021-11-06T08:00:00+08":"No trading on Saturday","2021-11-07T08:00:00+08":"No trading on Sunday","2021-11-11T08:00:00+08":"USD bank holiday (triangulation)","2021-11-13T08:00:00+08":"No trading on Saturday","2021-11-14T08:00:00+08":"No trading on Sunday","2021-11-20T08:00:00+08":"No trading on Saturday","2021-11-21T08:00:00+08":"No trading on Sunday","2021-11-25T08:00:00+08":"USD bank holiday (triangulation)","2021-11-27T08:00:00+08":"No trading on Saturday","2021-11-28T08:00:00+08":"No trading on Sunday","2021-12-04T08:00:00+08":"No trading on Saturday","2021-12-05T08:00:00+08":"No trading on Sunday","2021-12-11T08:00:00+08":"No trading on Saturday","2021-12-12T08:00:00+08":"No trading on Sunday","2021-12-18T08:00:00+08":"No trading on Saturday","2021-12-19T08:00:00+08":"No trading on Sunday","2021-12-25T08:00:00+08":"No trading on Saturday","2021-12-26T08:00:00+08":"No trading on Sunday","2021-12-27T08:00:00+08":"Christmas OBS","2021-12-28T08:00:00+08":"Boxing Day OBS","2022-01-01T08:00:00+08":"No trading on Saturday","2022-01-02T08:00:00+08":"No trading on Sunday","2022-01-03T08:00:00+08":"New Year's Day OBS","2022-01-08T08:00:00+08":"No trading on Saturday","2022-01-09T08:00:00+08":"No trading on Sunday","2022-01-15T08:00:00+08":"No trading on Saturday","2022-01-16T08:00:00+08":"No trading on Sunday","2022-01-17T08:00:00+08":"USD bank holiday (triangulation)","2022-01-22T08:00:00+08":"No trading on Saturday","2022-01-23T08:00:00+08":"No trading on Sunday","2022-01-29T08:00:00+08":"No trading on Saturday","2022-01-30T08:00:00+08":"No trading on Sunday","2022-01-31T08:00:00+08":"Lunar NY Eve 1","2022-02-01T08:00:00+08":"Lunar New Year 1","2022-02-02T08:00:00+08":"Lunar New Year 2","2022-02-03T08:00:00+08":"Lunar New Year 3","2022-02-04T08:00:00+08":"Lunar New Year 4","2022-02-05T08:00:00+08":"No trading on Saturday","2022-02-06T08:00:00+08":"No trading on Sunday","2022-02-12T08:00:00+08":"No trading on Saturday","2022-02-13T08:00:00+08":"No trading on Sunday","2022-02-19T08:00:00+08":"No trading on Saturday","2022-02-20T08:00:00+08":"No trading on Sunday","2022-02-21T08:00:00+08":"USD bank holiday (triangulation)","2022-02-26T08:00:00+08":"No trading on Saturday","2022-02-27T08:00:00+08":"No trading on Sunday","2022-03-05T08:00:00+08":"No trading on Saturday","2022-03-06T08:00:00+08":"No trading on Sunday","2022-03-12T08:00:00+08":"No trading on Saturday","2022-03-13T08:00:00+08":"No trading on Sunday","2022-03-19T08:00:00+08":"No trading on Saturday","2022-03-20T08:00:00+08":"No trading on Sunday","2022-03-26T08:00:00+08":"No trading on Saturday","2022-03-27T08:00:00+08":"No trading on Sunday","2022-04-02T08:00:00+08":"No trading on Saturday","2022-04-03T08:00:00+08":"No trading on Sunday","2022-04-04T08:00:00+08":"Ching Ming Festival Holiday","2022-04-05T08:00:00+08":"Ching Ming Festival","2022-04-09T08:00:00+08":"No trading on Saturday","2022-04-10T08:00:00+08":"No trading on Sunday","2022-04-15T08:00:00+08":"Good Friday","2022-04-16T08:00:00+08":"No trading on Saturday","2022-04-17T08:00:00+08":"No trading on Sunday","2022-04-18T08:00:00+08":"Easter Monday","2022-04-23T08:00:00+08":"No trading on Saturday","2022-04-24T08:00:00+08":"No trading on Sunday","2022-04-30T08:00:00+08":"No trading on Saturday","2022-05-01T08:00:00+08":"No trading on Sunday","2022-05-02T08:00:00+08":"Early May Bank Holiday","2022-05-07T08:00:00+08":"No trading on Saturday","2022-05-08T08:00:00+08":"No trading on Sunday","2022-05-09T08:00:00+08":"HKD bank holiday (triangulation)","2022-05-14T08:00:00+08":"No trading on Saturday","2022-05-15T08:00:00+08":"No trading on Sunday","2022-05-21T08:00:00+08":"No trading on Saturday","2022-05-22T08:00:00+08":"No trading on Sunday","2022-05-28T08:00:00+08":"No trading on Saturday","2022-05-29T08:00:00+08":"No trading on Sunday","2022-05-30T08:00:00+08":"Late May Bank Holiday","2022-06-03T08:00:00+08":"Dragon Boat Festival (Tuen Ng Day)*","2022-06-04T08:00:00+08":"No trading on Saturday","2022-06-05T08:00:00+08":"No trading on Sunday","2022-06-11T08:00:00+08":"No trading on Saturday","2022-06-12T08:00:00+08":"No trading on Sunday","2022-06-18T08:00:00+08":"No trading on Saturday","2022-06-19T08:00:00+08":"No trading on Sunday","2022-06-25T08:00:00+08":"No trading on Saturday","2022-06-26T08:00:00+08":"No trading on Sunday","2022-07-01T08:00:00+08":"HKD bank holiday (triangulation)","2022-07-02T08:00:00+08":"No trading on Saturday","2022-07-03T08:00:00+08":"No trading on Sunday","2022-07-04T08:00:00+08":"USD bank holiday (triangulation)","2022-07-09T08:00:00+08":"No trading on Saturday","2022-07-10T08:00:00+08":"No trading on Sunday","2022-07-16T08:00:00+08":"No trading on Saturday","2022-07-17T08:00:00+08":"No trading on Sunday","2022-07-23T08:00:00+08":"No trading on Saturday","2022-07-24T08:00:00+08":"No trading on Sunday","2022-07-30T08:00:00+08":"No trading on Saturday","2022-07-31T08:00:00+08":"No trading on Sunday","2022-08-06T08:00:00+08":"No trading on Saturday","2022-08-07T08:00:00+08":"No trading on Sunday","2022-08-13T08:00:00+08":"No trading on Saturday","2022-08-14T08:00:00+08":"No trading on Sunday","2022-08-20T08:00:00+08":"No trading on Saturday","2022-08-21T08:00:00+08":"No trading on Sunday","2022-08-27T08:00:00+08":"No trading on Saturday","2022-08-28T08:00:00+08":"No trading on Sunday","2022-08-29T08:00:00+08":"Summer Bank Holiday","2022-09-03T08:00:00+08":"No trading on Saturday","2022-09-04T08:00:00+08":"No trading on Sunday","2022-09-05T08:00:00+08":"USD bank holiday (triangulation)","2022-09-10T08:00:00+08":"No trading on Saturday","2022-09-11T08:00:00+08":"No trading on Sunday","2022-09-12T08:00:00+08":"Mid-autumn Festival Holiday","2022-09-17T08:00:00+08":"No trading on Saturday","2022-09-18T08:00:00+08":"No trading on Sunday","2022-09-24T08:00:00+08":"No trading on Saturday","2022-09-25T08:00:00+08":"No trading on Sunday","2022-10-01T08:00:00+08":"No trading on Saturday","2022-10-02T08:00:00+08":"No trading on Sunday","2022-10-03T08:00:00+08":"National Day 3","2022-10-04T08:00:00+08":"National Day 4","2022-10-05T08:00:00+08":"National Day 5","2022-10-06T08:00:00+08":"National Day 6","2022-10-07T08:00:00+08":"National Day 7","2022-10-08T08:00:00+08":"No trading on Saturday","2022-10-09T08:00:00+08":"No trading on Sunday","2022-10-10T08:00:00+08":"USD bank holiday (triangulation)","2022-10-15T08:00:00+08":"No trading on Saturday","2022-10-16T08:00:00+08":"No trading on Sunday","2022-10-22T08:00:00+08":"No trading on Saturday","2022-10-23T08:00:00+08":"No trading on Sunday","2022-10-29T08:00:00+08":"No trading on Saturday","2022-10-30T08:00:00+08":"No trading on Sunday","2022-11-11T08:00:00+08":"USD bank holiday (triangulation)","2022-11-24T08:00:00+08":"USD bank holiday (triangulation)","2022-12-26T08:00:00+08":"Christmas OBS","2022-12-27T08:00:00+08":"Boxing Day OBS"}}
//       referenceConversionDates conversionDates=== {"defaultConversionDate":"2020-11-03T08:00:00+08","firstConversionDate":"2020-10-30T08:00:00+08","invalidConversionDates":{"2020-10-31T08:00:00+08":"No trading on Saturday","2020-11-01T08:00:00+08":"No trading on Sunday","2020-11-07T08:00:00+08":"No trading on Saturday","2020-11-08T08:00:00+08":"No trading on Sunday","2020-11-11T08:00:00+08":"USD bank holiday (triangulation)","2020-11-14T08:00:00+08":"No trading on Saturday","2020-11-15T08:00:00+08":"No trading on Sunday","2020-11-21T08:00:00+08":"No trading on Saturday","2020-11-22T08:00:00+08":"No trading on Sunday","2020-11-26T08:00:00+08":"USD bank holiday (triangulation)","2020-11-28T08:00:00+08":"No trading on Saturday","2020-11-29T08:00:00+08":"No trading on Sunday","2020-12-05T08:00:00+08":"No trading on Saturday","2020-12-06T08:00:00+08":"No trading on Sunday","2020-12-12T08:00:00+08":"No trading on Saturday","2020-12-13T08:00:00+08":"No trading on Sunday","2020-12-19T08:00:00+08":"No trading on Saturday","2020-12-20T08:00:00+08":"No trading on Sunday","2020-12-25T08:00:00+08":"Christmas","2020-12-26T08:00:00+08":"No trading on Saturday","2020-12-27T08:00:00+08":"No trading on Sunday","2020-12-28T08:00:00+08":"Boxing Day OBS","2021-01-01T08:00:00+08":"New Year's Day","2021-01-02T08:00:00+08":"No trading on Saturday","2021-01-03T08:00:00+08":"No trading on Sunday","2021-01-09T08:00:00+08":"No trading on Saturday","2021-01-10T08:00:00+08":"No trading on Sunday","2021-01-16T08:00:00+08":"No trading on Saturday","2021-01-17T08:00:00+08":"No trading on Sunday","2021-01-18T08:00:00+08":"USD bank holiday (triangulation)","2021-01-23T08:00:00+08":"No trading on Saturday","2021-01-24T08:00:00+08":"No trading on Sunday","2021-01-30T08:00:00+08":"No trading on Saturday","2021-01-31T08:00:00+08":"No trading on Sunday","2021-02-06T08:00:00+08":"No trading on Saturday","2021-02-07T08:00:00+08":"No trading on Sunday","2021-02-11T08:00:00+08":"Lunar NY Eve 1","2021-02-12T08:00:00+08":"Lunar New Year 1","2021-02-13T08:00:00+08":"No trading on Saturday","2021-02-14T08:00:00+08":"No trading on Sunday","2021-02-15T08:00:00+08":"Lunar New Year 4","2021-02-16T08:00:00+08":"Lunar New Year 5","2021-02-17T08:00:00+08":"Lunar New Year 6","2021-02-20T08:00:00+08":"No trading on Saturday","2021-02-21T08:00:00+08":"No trading on Sunday","2021-02-27T08:00:00+08":"No trading on Saturday","2021-02-28T08:00:00+08":"No trading on Sunday","2021-03-06T08:00:00+08":"No trading on Saturday","2021-03-07T08:00:00+08":"No trading on Sunday","2021-03-13T08:00:00+08":"No trading on Saturday","2021-03-14T08:00:00+08":"No trading on Sunday","2021-03-20T08:00:00+08":"No trading on Saturday","2021-03-21T08:00:00+08":"No trading on Sunday","2021-03-27T08:00:00+08":"No trading on Saturday","2021-03-28T08:00:00+08":"No trading on Sunday","2021-04-02T08:00:00+08":"Good Friday","2021-04-03T08:00:00+08":"No trading on Saturday","2021-04-04T08:00:00+08":"No trading on Sunday","2021-04-05T08:00:00+08":"Easter Monday","2021-04-06T08:00:00+08":"HKD bank holiday (triangulation)","2021-04-10T08:00:00+08":"No trading on Saturday","2021-04-11T08:00:00+08":"No trading on Sunday","2021-04-17T08:00:00+08":"No trading on Saturday","2021-04-18T08:00:00+08":"No trading on Sunday","2021-04-24T08:00:00+08":"No trading on Saturday","2021-04-25T08:00:00+08":"No trading on Sunday","2021-05-01T08:00:00+08":"No trading on Saturday","2021-05-02T08:00:00+08":"No trading on Sunday","2021-05-03T08:00:00+08":"Early May Bank Holiday","2021-05-08T08:00:00+08":"No trading on Saturday","2021-05-09T08:00:00+08":"No trading on Sunday","2021-05-15T08:00:00+08":"No trading on Saturday","2021-05-16T08:00:00+08":"No trading on Sunday","2021-05-19T08:00:00+08":"HKD bank holiday (triangulation)","2021-05-22T08:00:00+08":"No trading on Saturday","2021-05-23T08:00:00+08":"No trading on Sunday","2021-05-29T08:00:00+08":"No trading on Saturday","2021-05-30T08:00:00+08":"No trading on Sunday","2021-05-31T08:00:00+08":"Late May Bank Holiday","2021-06-05T08:00:00+08":"No trading on Saturday","2021-06-06T08:00:00+08":"No trading on Sunday","2021-06-12T08:00:00+08":"No trading on Saturday","2021-06-13T08:00:00+08":"No trading on Sunday","2021-06-14T08:00:00+08":"Dragon Boat Festival (Tuen Ng Day)*","2021-06-19T08:00:00+08":"No trading on Saturday","2021-06-20T08:00:00+08":"No trading on Sunday","2021-06-26T08:00:00+08":"No trading on Saturday","2021-06-27T08:00:00+08":"No trading on Sunday","2021-07-01T08:00:00+08":"HKD bank holiday (triangulation)","2021-07-03T08:00:00+08":"No trading on Saturday","2021-07-04T08:00:00+08":"No trading on Sunday","2021-07-05T08:00:00+08":"USD bank holiday (triangulation)","2021-07-10T08:00:00+08":"No trading on Saturday","2021-07-11T08:00:00+08":"No trading on Sunday","2021-07-17T08:00:00+08":"No trading on Saturday","2021-07-18T08:00:00+08":"No trading on Sunday","2021-07-24T08:00:00+08":"No trading on Saturday","2021-07-25T08:00:00+08":"No trading on Sunday","2021-07-31T08:00:00+08":"No trading on Saturday","2021-08-01T08:00:00+08":"No trading on Sunday","2021-08-07T08:00:00+08":"No trading on Saturday","2021-08-08T08:00:00+08":"No trading on Sunday","2021-08-14T08:00:00+08":"No trading on Saturday","2021-08-15T08:00:00+08":"No trading on Sunday","2021-08-21T08:00:00+08":"No trading on Saturday","2021-08-22T08:00:00+08":"No trading on Sunday","2021-08-28T08:00:00+08":"No trading on Saturday","2021-08-29T08:00:00+08":"No trading on Sunday","2021-08-30T08:00:00+08":"Summer Bank Holiday","2021-09-04T08:00:00+08":"No trading on Saturday","2021-09-05T08:00:00+08":"No trading on Sunday","2021-09-06T08:00:00+08":"USD bank holiday (triangulation)","2021-09-11T08:00:00+08":"No trading on Saturday","2021-09-12T08:00:00+08":"No trading on Sunday","2021-09-18T08:00:00+08":"No trading on Saturday","2021-09-19T08:00:00+08":"No trading on Sunday","2021-09-20T08:00:00+08":"Mid-autumn Festival Holiday","2021-09-21T08:00:00+08":"Mid-autumn Festival*","2021-09-22T08:00:00+08":"HKD bank holiday (triangulation)","2021-09-25T08:00:00+08":"No trading on Saturday","2021-09-26T08:00:00+08":"No trading on Sunday","2021-10-01T08:00:00+08":"National Day 1","2021-10-02T08:00:00+08":"No trading on Saturday","2021-10-03T08:00:00+08":"No trading on Sunday","2021-10-04T08:00:00+08":"National Day 4","2021-10-05T08:00:00+08":"National Day 5","2021-10-06T08:00:00+08":"National Day 6","2021-10-07T08:00:00+08":"National Day 7","2021-10-09T08:00:00+08":"No trading on Saturday","2021-10-10T08:00:00+08":"No trading on Sunday","2021-10-11T08:00:00+08":"USD bank holiday (triangulation)","2021-10-14T08:00:00+08":"HKD bank holiday (triangulation)","2021-10-16T08:00:00+08":"No trading on Saturday","2021-10-17T08:00:00+08":"No trading on Sunday","2021-10-23T08:00:00+08":"No trading on Saturday","2021-10-24T08:00:00+08":"No trading on Sunday","2021-10-30T08:00:00+08":"No trading on Saturday","2021-10-31T08:00:00+08":"No trading on Sunday","2021-11-06T08:00:00+08":"No trading on Saturday","2021-11-07T08:00:00+08":"No trading on Sunday","2021-11-11T08:00:00+08":"USD bank holiday (triangulation)","2021-11-13T08:00:00+08":"No trading on Saturday","2021-11-14T08:00:00+08":"No trading on Sunday","2021-11-20T08:00:00+08":"No trading on Saturday","2021-11-21T08:00:00+08":"No trading on Sunday","2021-11-25T08:00:00+08":"USD bank holiday (triangulation)","2021-11-27T08:00:00+08":"No trading on Saturday","2021-11-28T08:00:00+08":"No trading on Sunday","2021-12-04T08:00:00+08":"No trading on Saturday","2021-12-05T08:00:00+08":"No trading on Sunday","2021-12-11T08:00:00+08":"No trading on Saturday","2021-12-12T08:00:00+08":"No trading on Sunday","2021-12-18T08:00:00+08":"No trading on Saturday","2021-12-19T08:00:00+08":"No trading on Sunday","2021-12-25T08:00:00+08":"No trading on Saturday","2021-12-26T08:00:00+08":"No trading on Sunday","2021-12-27T08:00:00+08":"Christmas OBS","2021-12-28T08:00:00+08":"Boxing Day OBS","2022-01-01T08:00:00+08":"No trading on Saturday","2022-01-02T08:00:00+08":"No trading on Sunday","2022-01-03T08:00:00+08":"New Year's Day OBS","2022-01-08T08:00:00+08":"No trading on Saturday","2022-01-09T08:00:00+08":"No trading on Sunday","2022-01-15T08:00:00+08":"No trading on Saturday","2022-01-16T08:00:00+08":"No trading on Sunday","2022-01-17T08:00:00+08":"USD bank holiday (triangulation)","2022-01-22T08:00:00+08":"No trading on Saturday","2022-01-23T08:00:00+08":"No trading on Sunday","2022-01-29T08:00:00+08":"No trading on Saturday","2022-01-30T08:00:00+08":"No trading on Sunday","2022-01-31T08:00:00+08":"Lunar NY Eve 1","2022-02-01T08:00:00+08":"Lunar New Year 1","2022-02-02T08:00:00+08":"Lunar New Year 2","2022-02-03T08:00:00+08":"Lunar New Year 3","2022-02-04T08:00:00+08":"Lunar New Year 4","2022-02-05T08:00:00+08":"No trading on Saturday","2022-02-06T08:00:00+08":"No trading on Sunday","2022-02-12T08:00:00+08":"No trading on Saturday","2022-02-13T08:00:00+08":"No trading on Sunday","2022-02-19T08:00:00+08":"No trading on Saturday","2022-02-20T08:00:00+08":"No trading on Sunday","2022-02-21T08:00:00+08":"USD bank holiday (triangulation)","2022-02-26T08:00:00+08":"No trading on Saturday","2022-02-27T08:00:00+08":"No trading on Sunday","2022-03-05T08:00:00+08":"No trading on Saturday","2022-03-06T08:00:00+08":"No trading on Sunday","2022-03-12T08:00:00+08":"No trading on Saturday","2022-03-13T08:00:00+08":"No trading on Sunday","2022-03-19T08:00:00+08":"No trading on Saturday","2022-03-20T08:00:00+08":"No trading on Sunday","2022-03-26T08:00:00+08":"No trading on Saturday","2022-03-27T08:00:00+08":"No trading on Sunday","2022-04-02T08:00:00+08":"No trading on Saturday","2022-04-03T08:00:00+08":"No trading on Sunday","2022-04-04T08:00:00+08":"Ching Ming Festival Holiday","2022-04-05T08:00:00+08":"Ching Ming Festival","2022-04-09T08:00:00+08":"No trading on Saturday","2022-04-10T08:00:00+08":"No trading on Sunday","2022-04-15T08:00:00+08":"Good Friday","2022-04-16T08:00:00+08":"No trading on Saturday","2022-04-17T08:00:00+08":"No trading on Sunday","2022-04-18T08:00:00+08":"Easter Monday","2022-04-23T08:00:00+08":"No trading on Saturday","2022-04-24T08:00:00+08":"No trading on Sunday","2022-04-30T08:00:00+08":"No trading on Saturday","2022-05-01T08:00:00+08":"No trading on Sunday","2022-05-02T08:00:00+08":"Early May Bank Holiday","2022-05-07T08:00:00+08":"No trading on Saturday","2022-05-08T08:00:00+08":"No trading on Sunday","2022-05-09T08:00:00+08":"HKD bank holiday (triangulation)","2022-05-14T08:00:00+08":"No trading on Saturday","2022-05-15T08:00:00+08":"No trading on Sunday","2022-05-21T08:00:00+08":"No trading on Saturday","2022-05-22T08:00:00+08":"No trading on Sunday","2022-05-28T08:00:00+08":"No trading on Saturday","2022-05-29T08:00:00+08":"No trading on Sunday","2022-05-30T08:00:00+08":"Late May Bank Holiday","2022-06-03T08:00:00+08":"Dragon Boat Festival (Tuen Ng Day)*","2022-06-04T08:00:00+08":"No trading on Saturday","2022-06-05T08:00:00+08":"No trading on Sunday","2022-06-11T08:00:00+08":"No trading on Saturday","2022-06-12T08:00:00+08":"No trading on Sunday","2022-06-18T08:00:00+08":"No trading on Saturday","2022-06-19T08:00:00+08":"No trading on Sunday","2022-06-25T08:00:00+08":"No trading on Saturday","2022-06-26T08:00:00+08":"No trading on Sunday","2022-07-01T08:00:00+08":"HKD bank holiday (triangulation)","2022-07-02T08:00:00+08":"No trading on Saturday","2022-07-03T08:00:00+08":"No trading on Sunday","2022-07-04T08:00:00+08":"USD bank holiday (triangulation)","2022-07-09T08:00:00+08":"No trading on Saturday","2022-07-10T08:00:00+08":"No trading on Sunday","2022-07-16T08:00:00+08":"No trading on Saturday","2022-07-17T08:00:00+08":"No trading on Sunday","2022-07-23T08:00:00+08":"No trading on Saturday","2022-07-24T08:00:00+08":"No trading on Sunday","2022-07-30T08:00:00+08":"No trading on Saturday","2022-07-31T08:00:00+08":"No trading on Sunday","2022-08-06T08:00:00+08":"No trading on Saturday","2022-08-07T08:00:00+08":"No trading on Sunday","2022-08-13T08:00:00+08":"No trading on Saturday","2022-08-14T08:00:00+08":"No trading on Sunday","2022-08-20T08:00:00+08":"No trading on Saturday","2022-08-21T08:00:00+08":"No trading on Sunday","2022-08-27T08:00:00+08":"No trading on Saturday","2022-08-28T08:00:00+08":"No trading on Sunday","2022-08-29T08:00:00+08":"Summer Bank Holiday","2022-09-03T08:00:00+08":"No trading on Saturday","2022-09-04T08:00:00+08":"No trading on Sunday","2022-09-05T08:00:00+08":"USD bank holiday (triangulation)","2022-09-10T08:00:00+08":"No trading on Saturday","2022-09-11T08:00:00+08":"No trading on Sunday","2022-09-12T08:00:00+08":"Mid-autumn Festival Holiday","2022-09-17T08:00:00+08":"No trading on Saturday","2022-09-18T08:00:00+08":"No trading on Sunday","2022-09-24T08:00:00+08":"No trading on Saturday","2022-09-25T08:00:00+08":"No trading on Sunday","2022-10-01T08:00:00+08":"No trading on Saturday","2022-10-02T08:00:00+08":"No trading on Sunday","2022-10-03T08:00:00+08":"National Day 3","2022-10-04T08:00:00+08":"National Day 4","2022-10-05T08:00:00+08":"National Day 5","2022-10-06T08:00:00+08":"National Day 6","2022-10-07T08:00:00+08":"National Day 7","2022-10-08T08:00:00+08":"No trading on Saturday","2022-10-09T08:00:00+08":"No trading on Sunday","2022-10-10T08:00:00+08":"USD bank holiday (triangulation)","2022-10-15T08:00:00+08":"No trading on Saturday","2022-10-16T08:00:00+08":"No trading on Sunday","2022-10-22T08:00:00+08":"No trading on Saturday","2022-10-23T08:00:00+08":"No trading on Sunday","2022-10-29T08:00:00+08":"No trading on Saturday","2022-10-30T08:00:00+08":"No trading on Sunday","2022-11-11T08:00:00+08":"USD bank holiday (triangulation)","2022-11-24T08:00:00+08":"USD bank holiday (triangulation)","2022-12-26T08:00:00+08":"Christmas OBS","2022-12-27T08:00:00+08":"Boxing Day OBS"}}
        //2020-11-01
//       referenceConversionDates conversionDates=== {"defaultConversionDate":"2020-11-03T08:00:00+08","firstConversionDate":"2020-10-30T08:00:00+08","invalidConversionDates":{"2020-10-31T08:00:00+08":"No trading on Saturday","2020-11-01T08:00:00+08":"No trading on Sunday","2020-11-07T08:00:00+08":"No trading on Saturday","2020-11-08T08:00:00+08":"No trading on Sunday","2020-11-11T08:00:00+08":"USD bank holiday (triangulation)","2020-11-14T08:00:00+08":"No trading on Saturday","2020-11-15T08:00:00+08":"No trading on Sunday","2020-11-21T08:00:00+08":"No trading on Saturday","2020-11-22T08:00:00+08":"No trading on Sunday","2020-11-26T08:00:00+08":"USD bank holiday (triangulation)","2020-11-28T08:00:00+08":"No trading on Saturday","2020-11-29T08:00:00+08":"No trading on Sunday","2020-12-05T08:00:00+08":"No trading on Saturday","2020-12-06T08:00:00+08":"No trading on Sunday","2020-12-12T08:00:00+08":"No trading on Saturday","2020-12-13T08:00:00+08":"No trading on Sunday","2020-12-19T08:00:00+08":"No trading on Saturday","2020-12-20T08:00:00+08":"No trading on Sunday","2020-12-25T08:00:00+08":"Christmas","2020-12-26T08:00:00+08":"No trading on Saturday","2020-12-27T08:00:00+08":"No trading on Sunday","2020-12-28T08:00:00+08":"Boxing Day OBS","2021-01-01T08:00:00+08":"New Year's Day","2021-01-02T08:00:00+08":"No trading on Saturday","2021-01-03T08:00:00+08":"No trading on Sunday","2021-01-09T08:00:00+08":"No trading on Saturday","2021-01-10T08:00:00+08":"No trading on Sunday","2021-01-16T08:00:00+08":"No trading on Saturday","2021-01-17T08:00:00+08":"No trading on Sunday","2021-01-18T08:00:00+08":"USD bank holiday (triangulation)","2021-01-23T08:00:00+08":"No trading on Saturday","2021-01-24T08:00:00+08":"No trading on Sunday","2021-01-30T08:00:00+08":"No trading on Saturday","2021-01-31T08:00:00+08":"No trading on Sunday","2021-02-06T08:00:00+08":"No trading on Saturday","2021-02-07T08:00:00+08":"No trading on Sunday","2021-02-11T08:00:00+08":"Lunar NY Eve 1","2021-02-12T08:00:00+08":"Lunar New Year 1","2021-02-13T08:00:00+08":"No trading on Saturday","2021-02-14T08:00:00+08":"No trading on Sunday","2021-02-15T08:00:00+08":"Lunar New Year 4","2021-02-16T08:00:00+08":"Lunar New Year 5","2021-02-17T08:00:00+08":"Lunar New Year 6","2021-02-20T08:00:00+08":"No trading on Saturday","2021-02-21T08:00:00+08":"No trading on Sunday","2021-02-27T08:00:00+08":"No trading on Saturday","2021-02-28T08:00:00+08":"No trading on Sunday","2021-03-06T08:00:00+08":"No trading on Saturday","2021-03-07T08:00:00+08":"No trading on Sunday","2021-03-13T08:00:00+08":"No trading on Saturday","2021-03-14T08:00:00+08":"No trading on Sunday","2021-03-20T08:00:00+08":"No trading on Saturday","2021-03-21T08:00:00+08":"No trading on Sunday","2021-03-27T08:00:00+08":"No trading on Saturday","2021-03-28T08:00:00+08":"No trading on Sunday","2021-04-02T08:00:00+08":"Good Friday","2021-04-03T08:00:00+08":"No trading on Saturday","2021-04-04T08:00:00+08":"No trading on Sunday","2021-04-05T08:00:00+08":"Easter Monday","2021-04-06T08:00:00+08":"HKD bank holiday (triangulation)","2021-04-10T08:00:00+08":"No trading on Saturday","2021-04-11T08:00:00+08":"No trading on Sunday","2021-04-17T08:00:00+08":"No trading on Saturday","2021-04-18T08:00:00+08":"No trading on Sunday","2021-04-24T08:00:00+08":"No trading on Saturday","2021-04-25T08:00:00+08":"No trading on Sunday","2021-05-01T08:00:00+08":"No trading on Saturday","2021-05-02T08:00:00+08":"No trading on Sunday","2021-05-03T08:00:00+08":"Early May Bank Holiday","2021-05-08T08:00:00+08":"No trading on Saturday","2021-05-09T08:00:00+08":"No trading on Sunday","2021-05-15T08:00:00+08":"No trading on Saturday","2021-05-16T08:00:00+08":"No trading on Sunday","2021-05-19T08:00:00+08":"HKD bank holiday (triangulation)","2021-05-22T08:00:00+08":"No trading on Saturday","2021-05-23T08:00:00+08":"No trading on Sunday","2021-05-29T08:00:00+08":"No trading on Saturday","2021-05-30T08:00:00+08":"No trading on Sunday","2021-05-31T08:00:00+08":"Late May Bank Holiday","2021-06-05T08:00:00+08":"No trading on Saturday","2021-06-06T08:00:00+08":"No trading on Sunday","2021-06-12T08:00:00+08":"No trading on Saturday","2021-06-13T08:00:00+08":"No trading on Sunday","2021-06-14T08:00:00+08":"Dragon Boat Festival (Tuen Ng Day)*","2021-06-19T08:00:00+08":"No trading on Saturday","2021-06-20T08:00:00+08":"No trading on Sunday","2021-06-26T08:00:00+08":"No trading on Saturday","2021-06-27T08:00:00+08":"No trading on Sunday","2021-07-01T08:00:00+08":"HKD bank holiday (triangulation)","2021-07-03T08:00:00+08":"No trading on Saturday","2021-07-04T08:00:00+08":"No trading on Sunday","2021-07-05T08:00:00+08":"USD bank holiday (triangulation)","2021-07-10T08:00:00+08":"No trading on Saturday","2021-07-11T08:00:00+08":"No trading on Sunday","2021-07-17T08:00:00+08":"No trading on Saturday","2021-07-18T08:00:00+08":"No trading on Sunday","2021-07-24T08:00:00+08":"No trading on Saturday","2021-07-25T08:00:00+08":"No trading on Sunday","2021-07-31T08:00:00+08":"No trading on Saturday","2021-08-01T08:00:00+08":"No trading on Sunday","2021-08-07T08:00:00+08":"No trading on Saturday","2021-08-08T08:00:00+08":"No trading on Sunday","2021-08-14T08:00:00+08":"No trading on Saturday","2021-08-15T08:00:00+08":"No trading on Sunday","2021-08-21T08:00:00+08":"No trading on Saturday","2021-08-22T08:00:00+08":"No trading on Sunday","2021-08-28T08:00:00+08":"No trading on Saturday","2021-08-29T08:00:00+08":"No trading on Sunday","2021-08-30T08:00:00+08":"Summer Bank Holiday","2021-09-04T08:00:00+08":"No trading on Saturday","2021-09-05T08:00:00+08":"No trading on Sunday","2021-09-06T08:00:00+08":"USD bank holiday (triangulation)","2021-09-11T08:00:00+08":"No trading on Saturday","2021-09-12T08:00:00+08":"No trading on Sunday","2021-09-18T08:00:00+08":"No trading on Saturday","2021-09-19T08:00:00+08":"No trading on Sunday","2021-09-20T08:00:00+08":"Mid-autumn Festival Holiday","2021-09-21T08:00:00+08":"Mid-autumn Festival*","2021-09-22T08:00:00+08":"HKD bank holiday (triangulation)","2021-09-25T08:00:00+08":"No trading on Saturday","2021-09-26T08:00:00+08":"No trading on Sunday","2021-10-01T08:00:00+08":"National Day 1","2021-10-02T08:00:00+08":"No trading on Saturday","2021-10-03T08:00:00+08":"No trading on Sunday","2021-10-04T08:00:00+08":"National Day 4","2021-10-05T08:00:00+08":"National Day 5","2021-10-06T08:00:00+08":"National Day 6","2021-10-07T08:00:00+08":"National Day 7","2021-10-09T08:00:00+08":"No trading on Saturday","2021-10-10T08:00:00+08":"No trading on Sunday","2021-10-11T08:00:00+08":"USD bank holiday (triangulation)","2021-10-14T08:00:00+08":"HKD bank holiday (triangulation)","2021-10-16T08:00:00+08":"No trading on Saturday","2021-10-17T08:00:00+08":"No trading on Sunday","2021-10-23T08:00:00+08":"No trading on Saturday","2021-10-24T08:00:00+08":"No trading on Sunday","2021-10-30T08:00:00+08":"No trading on Saturday","2021-10-31T08:00:00+08":"No trading on Sunday","2021-11-06T08:00:00+08":"No trading on Saturday","2021-11-07T08:00:00+08":"No trading on Sunday","2021-11-11T08:00:00+08":"USD bank holiday (triangulation)","2021-11-13T08:00:00+08":"No trading on Saturday","2021-11-14T08:00:00+08":"No trading on Sunday","2021-11-20T08:00:00+08":"No trading on Saturday","2021-11-21T08:00:00+08":"No trading on Sunday","2021-11-25T08:00:00+08":"USD bank holiday (triangulation)","2021-11-27T08:00:00+08":"No trading on Saturday","2021-11-28T08:00:00+08":"No trading on Sunday","2021-12-04T08:00:00+08":"No trading on Saturday","2021-12-05T08:00:00+08":"No trading on Sunday","2021-12-11T08:00:00+08":"No trading on Saturday","2021-12-12T08:00:00+08":"No trading on Sunday","2021-12-18T08:00:00+08":"No trading on Saturday","2021-12-19T08:00:00+08":"No trading on Sunday","2021-12-25T08:00:00+08":"No trading on Saturday","2021-12-26T08:00:00+08":"No trading on Sunday","2021-12-27T08:00:00+08":"Christmas OBS","2021-12-28T08:00:00+08":"Boxing Day OBS","2022-01-01T08:00:00+08":"No trading on Saturday","2022-01-02T08:00:00+08":"No trading on Sunday","2022-01-03T08:00:00+08":"New Year's Day OBS","2022-01-08T08:00:00+08":"No trading on Saturday","2022-01-09T08:00:00+08":"No trading on Sunday","2022-01-15T08:00:00+08":"No trading on Saturday","2022-01-16T08:00:00+08":"No trading on Sunday","2022-01-17T08:00:00+08":"USD bank holiday (triangulation)","2022-01-22T08:00:00+08":"No trading on Saturday","2022-01-23T08:00:00+08":"No trading on Sunday","2022-01-29T08:00:00+08":"No trading on Saturday","2022-01-30T08:00:00+08":"No trading on Sunday","2022-01-31T08:00:00+08":"Lunar NY Eve 1","2022-02-01T08:00:00+08":"Lunar New Year 1","2022-02-02T08:00:00+08":"Lunar New Year 2","2022-02-03T08:00:00+08":"Lunar New Year 3","2022-02-04T08:00:00+08":"Lunar New Year 4","2022-02-05T08:00:00+08":"No trading on Saturday","2022-02-06T08:00:00+08":"No trading on Sunday","2022-02-12T08:00:00+08":"No trading on Saturday","2022-02-13T08:00:00+08":"No trading on Sunday","2022-02-19T08:00:00+08":"No trading on Saturday","2022-02-20T08:00:00+08":"No trading on Sunday","2022-02-21T08:00:00+08":"USD bank holiday (triangulation)","2022-02-26T08:00:00+08":"No trading on Saturday","2022-02-27T08:00:00+08":"No trading on Sunday","2022-03-05T08:00:00+08":"No trading on Saturday","2022-03-06T08:00:00+08":"No trading on Sunday","2022-03-12T08:00:00+08":"No trading on Saturday","2022-03-13T08:00:00+08":"No trading on Sunday","2022-03-19T08:00:00+08":"No trading on Saturday","2022-03-20T08:00:00+08":"No trading on Sunday","2022-03-26T08:00:00+08":"No trading on Saturday","2022-03-27T08:00:00+08":"No trading on Sunday","2022-04-02T08:00:00+08":"No trading on Saturday","2022-04-03T08:00:00+08":"No trading on Sunday","2022-04-04T08:00:00+08":"Ching Ming Festival Holiday","2022-04-05T08:00:00+08":"Ching Ming Festival","2022-04-09T08:00:00+08":"No trading on Saturday","2022-04-10T08:00:00+08":"No trading on Sunday","2022-04-15T08:00:00+08":"Good Friday","2022-04-16T08:00:00+08":"No trading on Saturday","2022-04-17T08:00:00+08":"No trading on Sunday","2022-04-18T08:00:00+08":"Easter Monday","2022-04-23T08:00:00+08":"No trading on Saturday","2022-04-24T08:00:00+08":"No trading on Sunday","2022-04-30T08:00:00+08":"No trading on Saturday","2022-05-01T08:00:00+08":"No trading on Sunday","2022-05-02T08:00:00+08":"Early May Bank Holiday","2022-05-07T08:00:00+08":"No trading on Saturday","2022-05-08T08:00:00+08":"No trading on Sunday","2022-05-09T08:00:00+08":"HKD bank holiday (triangulation)","2022-05-14T08:00:00+08":"No trading on Saturday","2022-05-15T08:00:00+08":"No trading on Sunday","2022-05-21T08:00:00+08":"No trading on Saturday","2022-05-22T08:00:00+08":"No trading on Sunday","2022-05-28T08:00:00+08":"No trading on Saturday","2022-05-29T08:00:00+08":"No trading on Sunday","2022-05-30T08:00:00+08":"Late May Bank Holiday","2022-06-03T08:00:00+08":"Dragon Boat Festival (Tuen Ng Day)*","2022-06-04T08:00:00+08":"No trading on Saturday","2022-06-05T08:00:00+08":"No trading on Sunday","2022-06-11T08:00:00+08":"No trading on Saturday","2022-06-12T08:00:00+08":"No trading on Sunday","2022-06-18T08:00:00+08":"No trading on Saturday","2022-06-19T08:00:00+08":"No trading on Sunday","2022-06-25T08:00:00+08":"No trading on Saturday","2022-06-26T08:00:00+08":"No trading on Sunday","2022-07-01T08:00:00+08":"HKD bank holiday (triangulation)","2022-07-02T08:00:00+08":"No trading on Saturday","2022-07-03T08:00:00+08":"No trading on Sunday","2022-07-04T08:00:00+08":"USD bank holiday (triangulation)","2022-07-09T08:00:00+08":"No trading on Saturday","2022-07-10T08:00:00+08":"No trading on Sunday","2022-07-16T08:00:00+08":"No trading on Saturday","2022-07-17T08:00:00+08":"No trading on Sunday","2022-07-23T08:00:00+08":"No trading on Saturday","2022-07-24T08:00:00+08":"No trading on Sunday","2022-07-30T08:00:00+08":"No trading on Saturday","2022-07-31T08:00:00+08":"No trading on Sunday","2022-08-06T08:00:00+08":"No trading on Saturday","2022-08-07T08:00:00+08":"No trading on Sunday","2022-08-13T08:00:00+08":"No trading on Saturday","2022-08-14T08:00:00+08":"No trading on Sunday","2022-08-20T08:00:00+08":"No trading on Saturday","2022-08-21T08:00:00+08":"No trading on Sunday","2022-08-27T08:00:00+08":"No trading on Saturday","2022-08-28T08:00:00+08":"No trading on Sunday","2022-08-29T08:00:00+08":"Summer Bank Holiday","2022-09-03T08:00:00+08":"No trading on Saturday","2022-09-04T08:00:00+08":"No trading on Sunday","2022-09-05T08:00:00+08":"USD bank holiday (triangulation)","2022-09-10T08:00:00+08":"No trading on Saturday","2022-09-11T08:00:00+08":"No trading on Sunday","2022-09-12T08:00:00+08":"Mid-autumn Festival Holiday","2022-09-17T08:00:00+08":"No trading on Saturday","2022-09-18T08:00:00+08":"No trading on Sunday","2022-09-24T08:00:00+08":"No trading on Saturday","2022-09-25T08:00:00+08":"No trading on Sunday","2022-10-01T08:00:00+08":"No trading on Saturday","2022-10-02T08:00:00+08":"No trading on Sunday","2022-10-03T08:00:00+08":"National Day 3","2022-10-04T08:00:00+08":"National Day 4","2022-10-05T08:00:00+08":"National Day 5","2022-10-06T08:00:00+08":"National Day 6","2022-10-07T08:00:00+08":"National Day 7","2022-10-08T08:00:00+08":"No trading on Saturday","2022-10-09T08:00:00+08":"No trading on Sunday","2022-10-10T08:00:00+08":"USD bank holiday (triangulation)","2022-10-15T08:00:00+08":"No trading on Saturday","2022-10-16T08:00:00+08":"No trading on Sunday","2022-10-22T08:00:00+08":"No trading on Saturday","2022-10-23T08:00:00+08":"No trading on Sunday","2022-10-29T08:00:00+08":"No trading on Saturday","2022-10-30T08:00:00+08":"No trading on Sunday","2022-11-11T08:00:00+08":"USD bank holiday (triangulation)","2022-11-24T08:00:00+08":"USD bank holiday (triangulation)","2022-12-26T08:00:00+08":"Christmas OBS","2022-12-27T08:00:00+08":"Boxing Day OBS"}}
    }
}