package com.liquidnet.service.goblin.service.manage;

import com.liquidnet.service.goblin.dto.vo.GoblinStoreGoodsCategoryVo;

import java.util.List;

public interface IGoblinStoreMgtCategoryService {
    /**
     * 店铺商品分类:列表
     *
     * @param storeId 店铺ID
     * @return List<GoblinStoreGoodsCategoryVo>
     */
    List<GoblinStoreGoodsCategoryVo> list(String storeId);

    /**
     * 店铺商品分类:添加
     *
     * @param storeId                    店铺ID
     * @param addStoreGoodsCategoryVos   List<GoblinStoreGoodsCategoryVo>
     * @param storeGoodsCategoryVosCache List<GoblinStoreGoodsCategoryVo>
     */
    void add(String storeId, List<GoblinStoreGoodsCategoryVo> addStoreGoodsCategoryVos, List<GoblinStoreGoodsCategoryVo> storeGoodsCategoryVosCache);

    /**
     * 店铺商品分类:编辑
     *
     * @param updateStoreGoodsCategoryVo GoblinStoreGoodsCategoryVo
     * @param storeGoodsCategoryVosCache List<GoblinStoreGoodsCategoryVo>
     * @return boolean
     */
    boolean edit(GoblinStoreGoodsCategoryVo updateStoreGoodsCategoryVo, List<GoblinStoreGoodsCategoryVo> storeGoodsCategoryVosCache);

    /**
     * 店铺商品分类:删除
     *
     * @param uid     UID
     * @param storeId 店铺ID
     * @param cateId  店铺分类ID
     * @return boolean
     */
    boolean del(String uid, String storeId, String cateId);
}
