package com.liquidnet.service.slime.dto.param;


import com.liquidnet.commons.lang.constant.LnsRegex;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

@ApiModel(value = "SlimeSponsorApplyParam", description = "创建主办入参")
@Data
public class SlimeSponsorApplyParam implements java.io.Serializable {
    private static final long serialVersionUID = 5869673418720222889L;

    @ApiModelProperty(position = 10, required = true, value = "是否跳过企业信息 0不跳过 1跳过")
    private Integer skipCompany;

    @ApiModelProperty(position = 11, required = true, value = "主办名称[30]", example = "测试")
    @Size(max = 30, message = "主办名称长度限制1-30位")
    @NotBlank(message = "名称不能为空")
    private String name;
    @ApiModelProperty(position = 12, required = true, value = "logo图", example = "https://img.zhengzai.tv/partner/2019/05/14/5cda2d0520177.png")
    @NotBlank(message = "logo图不能为空")
    private String logo;
    @ApiModelProperty(position = 13, required = true, value = "背景图", example = "https://img.zhengzai.tv/partner/2019/05/14/5cda2d0520177.png")
    @NotBlank(message = "背景图不能为空")
    private String background;
    @ApiModelProperty(position = 14, required = true, value = "介绍[1000]", example = "这是一段介绍文字")
    private String description;

    @ApiModelProperty(position = 15, required = true, value = "联系人姓名", example = "张三")
    @NotBlank
    private String contactName;
    @ApiModelProperty(position = 16, required = true, value = "联系人身份证号码", example = "102030199012120101")
    @NotBlank
    private String contactIdentity;
    @ApiModelProperty(position = 17, required = true, value = "联系人身份证正面照")
    @NotBlank
    private String contactIdentityObverse;
    @ApiModelProperty(position = 18, required = true, value = "联系人身份证反面照")
    @NotBlank
    private String contactIdentityReverse;
    @ApiModelProperty(position = 19, required = true, value = "联系人邮箱", example = "zhangsan@zhengzai.tv")
    @NotNull
    private String contactEmail;

    @ApiModelProperty(position = 20, required = false, value = "企业名称")
    private String companyName;
    @ApiModelProperty(position = 21, required = false, value = "营业执照编号")
    private String licenseCode;
    @ApiModelProperty(position = 22, required = false, value = "营业执照图片")
    private String licenseImg;

    @ApiModelProperty(position = 23, required = false, value = "法人姓名", example = "李四")
    private String legalName;
    @ApiModelProperty(position = 24, required = false, value = "法人身份证号码")
    @Pattern(regexp = LnsRegex.Valid.LETTER_NUMBER, message = "证件号格式有误")
    @Size(min = 1, max = 30, message = "证件号长度限制1-30位")
    private String legalIdentity;
    @ApiModelProperty(position = 25, required = false, value = "法人身份证正面照")
    private String legalIdentityObverse;
    @ApiModelProperty(position = 26, required = false, value = "法人身份证反面照")
    private String legalIdentityReverse;
}
