package com.liquidnet.client.admin.web.controller.zhengzai.sweet;

import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.common.annotation.Log;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.common.enums.BusinessType;
import com.liquidnet.client.admin.common.utils.poi.ExcelUtil;
import com.liquidnet.client.admin.zhengzai.sweet.dto.SweetActivityDrawExcelListDao;
import com.liquidnet.client.admin.zhengzai.sweet.service.ISweetIntegralActivityDrawService;
import com.liquidnet.service.sweet.dto.SweetActivityDrawListDao;
import com.liquidnet.service.sweet.dto.admin.SweetIntegralActivityDrawListSearchParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotEmpty;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 积分活动抽奖记录表 前端控制器
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-10-22
 */
@Api(tags = "积分活动管理")
@Validated
@Controller
@RequestMapping("/sweet/IntegralActivityDraw")
public class SweetIntegralActivityDrawController extends BaseController {
    private String prefix = "zhengzai/sweet/integralActivityDraw";

    @Autowired
    private ISweetIntegralActivityDrawService iSweetIntegralActivityDrawService;

    @Log(title = "积分活动抽奖列表数据", businessType = BusinessType.LIST)
    @RequiresPermissions("sweet:integralActivityDraw:list")
    @ApiOperation(value = "积分活动中奖列表数据")
    @PostMapping("list")
    @ResponseBody
    public TableDataInfo list(SweetIntegralActivityDrawListSearchParam listParam) {
        PageInfo<SweetActivityDrawListDao> result = iSweetIntegralActivityDrawService.drawList(listParam);
        return getDataTable(result.getList());
    }

    @Log(title = "积分活动导出抽奖列表数据", businessType = BusinessType.EXPORT)
    @RequiresPermissions("sweet:integralActivityDraw:exportExcel")
    @PostMapping("/export")
    @ResponseBody
    public AjaxResult export(@RequestParam("ids") String integralActivityId) {
        List<SweetActivityDrawListDao> list = iSweetIntegralActivityDrawService.selectExcelList(integralActivityId);
        ExcelUtil<SweetActivityDrawExcelListDao> excelUtil = new ExcelUtil<>(SweetActivityDrawExcelListDao.class);
        List<SweetActivityDrawExcelListDao> excelList = new ArrayList<>();
        list.forEach(r -> {
            excelList.add(SweetActivityDrawExcelListDao.getNew().copy(r));
        });
        return excelUtil.exportExcel(excelList, "积分活动导出中奖列表数据");
    }

    @Log(title = "积分活动中奖发货", businessType = BusinessType.UPDATE)
    @RequiresPermissions("sweet:integralActivityDraw:receivingStatus")
    @ApiOperation(value = "积分活动中奖发货")
    @PutMapping("receivingStatus")
    @ResponseBody
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "drawId", value = "抽奖id")
    })
    public AjaxResult receivingStatus(
            @RequestParam("drawId") @NotEmpty(message = "drawId不能为空") String drawId
    ) {
        Integer result = iSweetIntegralActivityDrawService.receivingStatus(drawId);
        if (result > 0) {
            return success("操作成功");
        } else {
            return error("操作失败");
        }
    }

    @GetMapping("listView/{id}")
    @ApiOperation(value = "积分活动中奖列表view")
    public String listView(@PathVariable("id") String id, ModelMap mmap) {
        mmap.put("integralActivityId", id);
        return prefix + "/list";
    }

}
