package com.liquidnet.service.sweet.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 积分活动抽奖记录表
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-10-20
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SweetIntegralActivityDraw implements Serializable, Cloneable {

    private static final long serialVersionUID = 7799235431503369544L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 抽奖id
     */
    private String drawId;

    /**
     * 关联活动id
     */
    private String integralActivityId;

    /**
     * 活动玩一次所需积分
     */
    private Integer activityNum;

    /**
     * 关联奖品id
     */
    private String prizeId;

    /**
     * 奖品名称
     */
    private String prizeTitle;

    /**
     * 奖品类型 1积分 2优惠券 3实物 4登登登VIP 5优先购买券
     */
    private Integer prizeType;

    /**
     * 关联id 如商品id 券id
     */
    private String relationId;

    /**
     * 单次奖励数量如积分 中奖给多少
     */
    private Integer prizeTypeNum;

    /**
     * 关联用户id
     */
    private String userId;

    /**
     * 关联用户昵称
     */
    private String nickname;

    /**
     * adam收货地址addresses_id
     */
    private String receivingAddressesId;

    /**
     * adam收货人姓名
     */
    private String receivingName;

    /**
     * adam收货人手机号
     */
    private String receivingPhone;

    /**
     * adam收货人地址省份
     */
    private String receivingProvince;

    /**
     * adam收货人地址城市
     */
    private String receivingCity;

    /**
     * adam收货人地址区县
     */
    private String receivingCounty;

    /**
     * adam收货人完整地址 空格隔离省市区详细地址
     */
    private String receivingAddress;

    /**
     * 发放状态 1未发放 2已发放 3未领取
     */
    private Integer receivingStatus;

    /**
     * 创建时间
     */
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime updatedAt;

    private static final SweetIntegralActivityDraw obj = new SweetIntegralActivityDraw();
    public static SweetIntegralActivityDraw getNew() {
        try {
            return (SweetIntegralActivityDraw) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetIntegralActivityDraw();
        }
    }


}
