package com.liquidnet.service.sweet.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
@ApiModel
public class SweetManualArtistListArDto implements Serializable, Cloneable {

    private static final long serialVersionUID = -5997109354033494326L;

    @ApiModelProperty("电子手册关联id")
    private String manualRelationId;
    @ApiModelProperty("艺人id")
    private String artistsId;
    @ApiModelProperty("艺人名称")
    private String name;
    @ApiModelProperty("艺人拼音")
    private String pinyin;
    @ApiModelProperty("艺人简介")
    private String describes;
    @ApiModelProperty("艺人头像图片")
    private String picUrl;
    @ApiModelProperty("舞台id")
    private String stageId;
    @ApiModelProperty("舞台名称")
    private String title;
    @ApiModelProperty("艺人演出开始")
    private String performanceStart;
    @ApiModelProperty("艺人演出开始时间戳 毫秒")
    private Long performanceStartDate;
    @ApiModelProperty("艺人演出结束")
    private String performanceEnd;
    @ApiModelProperty("艺人演出结束时间戳 毫秒")
    private Long performanceEndDate;
    @ApiModelProperty("艺人签售开始")
    private String signatureStart;
    @ApiModelProperty("艺人签售结束")
    private String signatureEnd;
    @ApiModelProperty("艺人资源url 目前是视频和图片 轮播图使用")
    private List<SweetManualArtistResourceUrlArDto> resourceUrl;

    private static final SweetManualArtistListArDto obj = new SweetManualArtistListArDto();

    public static SweetManualArtistListArDto getNew() {
        try {
            return (SweetManualArtistListArDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetManualArtistListArDto();
        }
    }

    /*public SweetManualArtistListArDto copy(SweetManualArtistListArDto source) {
        if (null == source) return this;
        this.setArtistId(source.getArtistId());
        return this;
    }*/
}
