package com.liquidnet.service.consumer.nft.service.processor;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.galaxy.constant.GalaxyEnum;
import com.liquidnet.service.galaxy.dto.param.GalaxyUserRegisterReqDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyUserRegisterRespDto;
import com.liquidnet.service.galaxy.router.xuper.biz.XuperUserCommonBiz;
import com.liquidnet.service.galaxy.router.zxin.biz.ZxinUserCommonBiz;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: ConsumerJsonNftPublishAndBuyProcessor
 * @Package com.liquidnet.service.consumer.kylin.service.processor
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/3/29 17:04
 */
@Slf4j
@Component
public class ConsumerGalaxyJsonNftUserRegisterProcessor {
    @Autowired
    private ZxinUserCommonBiz zxinUserCommonBiz;

    @Autowired
    private XuperUserCommonBiz xuperUserCommonBiz;

    /**
     * 执行用户注册
     * @param reqDto
     * @return
     */
    public ResponseDto<GalaxyUserRegisterRespDto> userRegister(GalaxyUserRegisterReqDto reqDto) {
        if(reqDto.getRouterType().equalsIgnoreCase(GalaxyEnum.RouterTypeEnum.ZXINCHAIN.getCode())){
            return zxinUserCommonBiz.userRegister(reqDto);
        }else if(reqDto.getRouterType().equalsIgnoreCase(GalaxyEnum.RouterTypeEnum.XUPER.getCode())){
            return xuperUserCommonBiz.userRegister(reqDto);
        }else{
            log.error("userRegister 区块链路由类型不存在 routerType : {}",reqDto.getRouterType());
            return ResponseDto.failure();
        }
    }
}
