package com.liquidnet.service.stone.service.impl;

import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.UserPathDto;
import com.liquidnet.service.stone.entity.StoneScoreItems;
import com.liquidnet.service.stone.service.IStoneScoreItemsService;
import com.liquidnet.service.stone.util.ObjectUtils;
import com.liquidnet.service.stone.util.StoneMongoUtils;
import com.liquidnet.service.stone.util.StoneRedisUtils;
import com.liquidnet.service.stone.vo.StoneItemListVo;
import com.liquidnet.service.stone.vo.StoneScoreItemVo;
import io.netty.util.internal.ObjectUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * <p>
 * 积分物品表 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-10-19
 */
@Service
@Slf4j
public class StoneScoreItemsServiceImpl implements IStoneScoreItemsService {

    @Autowired
    private StoneRedisUtils redisUtils;
    @Autowired
    private StoneMongoUtils mongoUtils;

    @Override
    public PageInfo<List<StoneItemListVo>> itemList(Integer page, Integer size) {
        PageInfo<List<StoneItemListVo>> mPageInfo;
        size = 40;
        if (page == null || page == 1 || page == 0) {
            page = 1;
        }
        List<StoneScoreItems> voList;
        HashMap<String, Object> info = mongoUtils.itemListPage(page, size);
        try {
            voList = (List<StoneScoreItems>) info.get("data");
        } catch (Exception e) {
            voList = new ArrayList();
            e.printStackTrace();
        }
        long count = (long) info.get("total");


        List<StoneItemListVo> returnVoList = ObjectUtils.getStoneItemListVoArrayList();
        for (int i = 0; i < voList.size(); i++) {
            StoneScoreItems vo = voList.get(i);
            StoneItemListVo returnVo = StoneItemListVo.getNew().copy(vo);
            returnVoList.add(returnVo);
        }

        mPageInfo = new PageInfo(returnVoList);
        mPageInfo.setTotal(count);

        log.info(UserPathDto.setData("积分商品列表", "", voList));
        return mPageInfo;
    }

    @Override
    public ResponseDto<StoneScoreItemVo> itemDetails(String itemId) {
        StoneScoreItems data = redisUtils.getItemData(itemId);
        if(redisUtils.getStoneGeneralSurplus(itemId)<=0){
            data.setStatus(8);
        }
        StoneScoreItemVo vo = StoneScoreItemVo.getNew().copy(data);
        return ResponseDto.success(vo);
    }
}
